/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

@NonNullByDefault
public class FollowThreadAction
extends Action {
    private final int fThreadId;
    private final TmfView fView;
    private final ITmfTrace fTrace;
    private final @Nullable String fThreadName;

    public FollowThreadAction(TmfView source, @Nullable String threadName, int threadId, ITmfTrace trace) {
        this.fView = source;
        this.fThreadName = threadName;
        this.fThreadId = threadId;
        this.fTrace = trace;
    }

    public String getText() {
        if (this.fThreadName == null) {
            return String.valueOf(Messages.FollowThreadAction_follow) + ' ' + this.fThreadId;
        }
        return String.valueOf(Messages.FollowThreadAction_follow) + ' ' + this.fThreadName + '/' + this.fThreadId;
    }

    public void run() {
        this.fView.broadcast((TmfSignal)new TmfThreadSelectedSignal((Object)this.fView, this.fThreadId, this.fTrace));
        super.run();
    }
}

