/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IToc;
import org.eclipse.help.IToc2;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.ITopic2;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.UAElement;
import org.w3c.dom.Element;

public class Toc
extends UAElement
implements IToc2 {
    public static final String NAME = "toc";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_HREF = "href";
    public static final String ATTRIBUTE_TOPIC = "topic";
    public static final String ATTRIBUTE_LINK_TO = "link_to";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_SORT = "sort";
    private ITocContribution contribution;
    private ITopic topic;
    private Map<String, ITopic> href2TopicMap;

    public Toc(IToc src) {
        super(NAME, src);
        this.setHref(src.getHref());
        this.setLabel(src.getLabel());
        ITopic topic = src.getTopic(null);
        if (topic != null) {
            this.setTopic(topic.getHref());
        }
        this.appendChildren(src.getChildren());
    }

    public Toc(Element src) {
        super(src);
    }

    private Map<String, ITopic> createHref2TopicMap() {
        HashMap<String, ITopic> map = new HashMap<String, ITopic>();
        if (this.topic != null) {
            map.put(this.topic.getHref(), this.topic);
        }
        ITopic[] topics = this.getTopics();
        int i = 0;
        while (i < topics.length) {
            this.createHref2TopicMapAux(map, topics[i]);
            ++i;
        }
        return map;
    }

    private void createHref2TopicMapAux(Map<String, ITopic> map, ITopic topic) {
        ITopic[] subtopics;
        String href = topic.getHref();
        if (href != null) {
            String simpleHref;
            map.put(href, topic);
            int anchorIx = href.lastIndexOf("#");
            if (anchorIx >= 0 && !map.containsKey(simpleHref = href.substring(0, anchorIx))) {
                map.put(simpleHref, topic);
            }
        }
        if ((subtopics = topic.getSubtopics()) != null) {
            int i = 0;
            while (i < subtopics.length) {
                if (subtopics[i] != null) {
                    this.createHref2TopicMapAux(map, subtopics[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public String getHref() {
        return this.getAttribute(ATTRIBUTE_HREF);
    }

    @Override
    public String getIcon() {
        return this.getAttribute(ATTRIBUTE_ICON);
    }

    @Override
    public boolean isSorted() {
        return "true".equalsIgnoreCase(this.getAttribute(ATTRIBUTE_SORT));
    }

    private Map<String, ITopic> getHref2TopicMap() {
        if (this.href2TopicMap == null) {
            this.href2TopicMap = this.createHref2TopicMap();
        }
        return this.href2TopicMap;
    }

    @Override
    public String getLabel() {
        return this.getAttribute(ATTRIBUTE_LABEL);
    }

    public String getLinkTo() {
        return this.getAttribute(ATTRIBUTE_LINK_TO);
    }

    public String getTopic() {
        return this.getAttribute(ATTRIBUTE_TOPIC);
    }

    @Override
    public ITopic getTopic(String href) {
        if (href == null) {
            if (this.topic == null) {
                this.topic = new ITopic2(){

                    @Override
                    public String getHref() {
                        return Toc.this.getTopic();
                    }

                    @Override
                    public String getLabel() {
                        return Toc.this.getLabel();
                    }

                    @Override
                    public ITopic[] getSubtopics() {
                        return Toc.this.getTopics();
                    }

                    @Override
                    public boolean isEnabled(IEvaluationContext context) {
                        return Toc.this.isEnabled(context);
                    }

                    @Override
                    public IUAElement[] getChildren() {
                        return new IUAElement[0];
                    }

                    @Override
                    public ICriteria[] getCriteria() {
                        return Toc.this.getCriteria();
                    }

                    @Override
                    public String getIcon() {
                        return null;
                    }

                    @Override
                    public boolean isSorted() {
                        return false;
                    }
                };
            }
            return this.topic;
        }
        return this.getHref2TopicMap().get(href);
    }

    @Override
    public ITopic[] getTopics() {
        return this.getChildren(ITopic.class);
    }

    @Override
    public ICriteria[] getCriteria() {
        return this.getChildren(ICriteria.class);
    }

    public void setLabel(String label) {
        this.setAttribute(ATTRIBUTE_LABEL, label);
    }

    public void setLinkTo(String linkTo) {
        this.setAttribute(ATTRIBUTE_LINK_TO, linkTo);
    }

    public void setTopic(String href) {
        this.setAttribute(ATTRIBUTE_TOPIC, href);
    }

    public void setHref(String href) {
        this.setAttribute(ATTRIBUTE_HREF, href);
    }

    public ITocContribution getTocContribution() {
        return this.contribution;
    }

    public void setTocContribution(ITocContribution contribution) {
        this.contribution = contribution;
    }
}

