/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.util.Util;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference,
ISizeProvider {
    public static final int INTERNAL_PROPERTY_OPENED = 529;
    public static final int INTERNAL_PROPERTY_CLOSED = 530;
    public static final int INTERNAL_PROPERTY_PINNED = 531;
    public static final int INTERNAL_PROPERTY_VISIBLE = 532;
    public static final int INTERNAL_PROPERTY_ZOOMED = 533;
    public static final int INTERNAL_PROPERTY_ACTIVE_CHILD_CHANGED = 534;
    public static final int INTERNAL_PROPERTY_MAXIMIZED = 535;
    public static int STATE_LAZY = 0;
    public static int STATE_CREATION_IN_PROGRESS = 1;
    public static int STATE_CREATED = 2;
    public static int STATE_DISPOSED = 3;
    static String MEMENTO_KEY = "memento";
    private int state = STATE_LAZY;
    protected IWorkbenchPart legacyPart;
    private boolean pinned = false;
    private ListenerList propChangeListeners = new ListenerList();
    private ListenerList internalPropChangeListeners = new ListenerList();
    private ListenerList partChangeListeners = new ListenerList();
    protected Map propertyCache = new HashMap();
    private IPropertyListener propertyChangeListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object source, int propId) {
            WorkbenchPartReference.this.partPropertyChanged(source, propId);
        }
    };
    private IPropertyChangeListener partPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchPartReference.this.partPropertyChanged(event);
        }
    };
    private IWorkbenchPage page;
    private MPart part;
    private IEclipseContext windowContext;
    private EventHandler contextEventHandler;

    public WorkbenchPartReference(IEclipseContext windowContext, IWorkbenchPage page, MPart part) {
        this.windowContext = windowContext;
        this.page = page;
        this.part = part;
        if (part != null) {
            part.getTransientData().put(IWorkbenchPartReference.class.getName(), this);
        }
    }

    private EventHandler createContextEventHandler() {
        if (this.contextEventHandler == null) {
            this.contextEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    MPart part;
                    Object element = event.getProperty("ChangedElement");
                    if (element == (part = WorkbenchPartReference.this.getModel()) && part.getContext() != null) {
                        part.getContext().set(this.getClass().getName(), (Object)this);
                        WorkbenchPartReference.this.unsubscribe();
                    }
                }
            };
        }
        return this.contextEventHandler;
    }

    public void subscribe() {
        IEventBroker broker = (IEventBroker)this.windowContext.get(IEventBroker.class);
        broker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", this.createContextEventHandler());
    }

    public void unsubscribe() {
        if (this.contextEventHandler != null) {
            IEventBroker broker = (IEventBroker)this.windowContext.get(IEventBroker.class);
            broker.unsubscribe(this.contextEventHandler);
            this.contextEventHandler = null;
        }
    }

    public boolean isDisposed() {
        return this.state == STATE_DISPOSED;
    }

    protected void checkReference() {
        if (this.state == STATE_DISPOSED) {
            throw new RuntimeException("Error: IWorkbenchPartReference disposed");
        }
    }

    public MPart getModel() {
        return this.part;
    }

    protected void partPropertyChanged(Object source, int propId) {
        IWorkbenchPart actualPart;
        this.firePropertyChange(propId);
        if (propId == 257 && (actualPart = this.getPart(false)) != null) {
            SaveablesList modelManager = (SaveablesList)actualPart.getSite().getService(ISaveablesLifecycleListener.class);
            modelManager.dirtyChanged(actualPart);
        }
    }

    protected void partPropertyChanged(PropertyChangeEvent event) {
        this.firePartPropertyChange(event);
    }

    protected void releaseReferences() {
    }

    void addInternalPropertyListener(IPropertyListener listener) {
        this.internalPropChangeListeners.add((Object)listener);
    }

    void removeInternalPropertyListener(IPropertyListener listener) {
        this.internalPropChangeListeners.remove((Object)listener);
    }

    protected void fireInternalPropertyChange(int id) {
        Object[] listeners = this.internalPropChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyListener)listeners[i]).propertyChanged(this, id);
            ++i;
        }
    }

    @Override
    public void addPropertyListener(IPropertyListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.add((Object)listener);
    }

    @Override
    public void removePropertyListener(IPropertyListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.remove((Object)listener);
    }

    @Override
    public String getTitle() {
        String title = this.legacyPart == null ? this.part.getLocalizedLabel() : this.legacyPart.getTitle();
        return Util.safeString(title);
    }

    @Override
    public String getTitleToolTip() {
        String toolTip = (String)this.part.getTransientData().get("e4_override_title_tool_tip_key");
        if (toolTip == null || toolTip.length() == 0) {
            toolTip = this.part.getLocalizedTooltip();
        }
        return Util.safeString(toolTip);
    }

    @Override
    public String getId() {
        String id = this.part.getElementId();
        int colonIndex = id.indexOf(58);
        return colonIndex == -1 ? id : id.substring(0, colonIndex);
    }

    protected String computeTitle() {
        return this.getRawTitle();
    }

    protected final String getRawTitle() {
        return Util.safeString(this.legacyPart.getTitle());
    }

    @Override
    public final Image getTitleImage() {
        if (this.isDisposed()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
        }
        WorkbenchWindow wbw = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.part != null && wbw.getModel().getRenderer() instanceof SWTPartRenderer) {
            SWTPartRenderer r = (SWTPartRenderer)wbw.getModel().getRenderer();
            return r.getImage((MUILabel)this.part);
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    void fireVisibilityChange() {
        this.fireInternalPropertyChange(532);
    }

    void fireZoomChange() {
        this.fireInternalPropertyChange(533);
    }

    protected void firePropertyChange(int id) {
        this.immediateFirePropertyChange(id);
    }

    private void immediateFirePropertyChange(int id) {
        UIListenerLogging.logPartReferencePropertyChange(this, id);
        Object[] listeners = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyListener)listeners[i]).propertyChanged(this.legacyPart, id);
            ++i;
        }
        this.fireInternalPropertyChange(id);
    }

    public abstract PartSite getSite();

    public abstract void initialize(IWorkbenchPart var1) throws PartInitException;

    void addPropertyListeners() {
        IWorkbenchPart workbenchPart = this.getPart(false);
        if (workbenchPart != null) {
            workbenchPart.addPropertyListener(this.propertyChangeListener);
            if (workbenchPart instanceof IWorkbenchPart3) {
                ((IWorkbenchPart3)workbenchPart).addPartPropertyListener(this.partPropertyChangeListener);
            }
        }
    }

    @Override
    public final IWorkbenchPart getPart(boolean restore) {
        if (this.isDisposed()) {
            return null;
        }
        if (this.legacyPart == null) {
            if (restore && this.part.getWidget() == null) {
                EPartService partService = (EPartService)this.windowContext.get(EPartService.class);
                partService.showPart(this.part, EPartService.PartState.CREATE);
            }
            if (this.part.getObject() instanceof CompatibilityPart) {
                CompatibilityPart compatibilityPart = (CompatibilityPart)this.part.getObject();
                if (compatibilityPart != null) {
                    this.legacyPart = compatibilityPart.getPart();
                }
            } else if (this.part.getObject() != null && this.part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
                return (IWorkbenchPart)this.part.getTransientData().get("e4Wrapper");
            }
        }
        return this.legacyPart;
    }

    public abstract IWorkbenchPart createPart() throws PartInitException;

    abstract IWorkbenchPart createErrorPart();

    public abstract IWorkbenchPart createErrorPart(IStatus var1);

    protected void doDisposeNestedParts() {
    }

    private void doDisposePart() {
        if (this.legacyPart != null) {
            this.fireInternalPropertyChange(530);
            try {
                this.legacyPart.removePropertyListener(this.propertyChangeListener);
                if (this.legacyPart instanceof IWorkbenchPart3) {
                    ((IWorkbenchPart3)this.legacyPart).removePartPropertyListener(this.partPropertyChangeListener);
                }
            }
            catch (Exception e) {
                WorkbenchPlugin.log(e);
            }
            this.legacyPart = null;
        }
    }

    public void setPinned(boolean newPinned) {
        if (this.isDisposed()) {
            return;
        }
        if (newPinned == this.pinned) {
            return;
        }
        this.pinned = newPinned;
        this.immediateFirePropertyChange(1);
        if (this.pinned) {
            this.part.getTags().add("Pin Adornment");
        } else {
            this.part.getTags().remove("Pin Adornment");
        }
        this.fireInternalPropertyChange(531);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public String getPartProperty(String key) {
        if (this.legacyPart != null) {
            if (this.legacyPart instanceof IWorkbenchPart3) {
                return ((IWorkbenchPart3)this.legacyPart).getPartProperty(key);
            }
        } else {
            return (String)this.propertyCache.get(key);
        }
        return null;
    }

    @Override
    public void addPartPropertyListener(IPropertyChangeListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.add((Object)listener);
    }

    @Override
    public void removePartPropertyListener(IPropertyChangeListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.remove((Object)listener);
    }

    protected void firePartPropertyChange(PropertyChangeEvent event) {
        Object[] l = this.partChangeListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IPropertyChangeListener)l[i]).propertyChange(event);
            ++i;
        }
    }

    protected void createPartProperties(IWorkbenchPart3 workbenchPart) {
        for (Map.Entry e : this.propertyCache.entrySet()) {
            workbenchPart.setPartProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    @Override
    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        ISizeProvider sizeProvider = (ISizeProvider)Adapters.adapt((Object)this.legacyPart, ISizeProvider.class);
        if (sizeProvider != null) {
            return sizeProvider.computePreferredSize(width, availableParallel, availablePerpendicular, preferredResult);
        }
        return preferredResult;
    }

    @Override
    public int getSizeFlags(boolean width) {
        ISizeProvider sizeProvider = (ISizeProvider)Adapters.adapt((Object)this.legacyPart, ISizeProvider.class);
        if (sizeProvider != null) {
            return sizeProvider.getSizeFlags(width);
        }
        return 0;
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.page;
    }

    public void setPage(IWorkbenchPage newPage) {
        this.page = newPage;
    }

    @Override
    public String getPartName() {
        return this.part.getLocalizedLabel();
    }

    @Override
    public String getContentDescription() {
        IWorkbenchPart workbenchPart = this.getPart(false);
        if (workbenchPart instanceof IWorkbenchPart2) {
            return ((IWorkbenchPart2)workbenchPart).getContentDescription();
        }
        return workbenchPart.getTitle();
    }

    @Override
    public boolean isDirty() {
        IWorkbenchPart part = this.getPart(false);
        ISaveablePart saveable = SaveableHelper.getSaveable(part);
        if (saveable != null) {
            return saveable.isDirty();
        }
        return false;
    }

    public void invalidate() {
        this.doDisposePart();
    }

    public final PartPane getPane() {
        return new PartPane(){

            @Override
            public Control getControl() {
                return WorkbenchPartReference.this.part == null ? null : (Control)WorkbenchPartReference.this.part.getWidget();
            }
        };
    }
}

