/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.AggregateResourcesEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractStateSystemTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractStateSystemTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    public static final @NonNull String RESOURCES_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CPU";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
        this.setAutoExpandLevel(1);
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        ResourcesEntry resourcesEntry;
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof ResourcesEntry && (resourcesEntry = (ResourcesEntry)sSel.getFirstElement()).getType().equals((Object)ResourcesEntry.Type.CPU)) {
            int cpu;
            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
            Integer data = (Integer)ctx.getData(RESOURCES_FOLLOW_CPU);
            int n = cpu = data != null ? data : -1;
            if (cpu >= 0) {
                menuManager.add((IAction)new UnfollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            } else {
                menuManager.add((IAction)new FollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            }
        }
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, final IProgressMonitor monitor) {
        long startTime;
        final ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        HashMap<Integer, ResourcesEntry> entryMap = new HashMap<Integer, ResourcesEntry>();
        ResourcesEntry traceEntry = null;
        long start = startTime = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), startTime));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long endTime = end + 1L;
            this.setEndTime(Math.max(this.getEndTime(), endTime));
            if (traceEntry == null) {
                traceEntry = new ResourcesEntry(trace, trace.getName(), startTime, endTime, 0);
                List<ResourcesEntry> entryList = Collections.singletonList(traceEntry);
                this.addToEntryList(parentTrace, ssq, entryList);
            } else {
                traceEntry.updateEndTime(endTime);
            }
            List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
            ResourcesView.createCpuEntriesWithQuark(trace, ssq, entryMap, traceEntry, startTime, endTime, cpuQuarks);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            final @NonNull List traceEntryChildren = traceEntry.getChildren();
            long resolution = Math.max(1L, (endTime - ssq.getStartTime()) / (long)this.getDisplayWidth());
            this.queryFullStates(ssq, ssq.getStartTime(), end, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

                public void handle(List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState) {
                    for (TimeGraphEntry child : traceEntryChildren) {
                        if (this.populateEventsRecursively(fullStates, prevFullState, child).isOK()) continue;
                        return;
                    }
                }

                private IStatus populateEventsRecursively(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull TimeGraphEntry entry) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    List<ITimeEvent> eventList = ResourcesView.this.getEventList(entry, ssq, fullStates, prevFullState, monitor);
                    if (eventList != null) {
                        if (prevFullState == null) {
                            entry.setEventList(eventList);
                        } else {
                            for (ITimeEvent event : eventList) {
                                entry.addEvent(event);
                            }
                        }
                    }
                    for (TimeGraphEntry child : entry.getChildren()) {
                        IStatus status = this.populateEventsRecursively(fullStates, prevFullState, child);
                        if (status.isOK()) continue;
                        return status;
                    }
                    return Status.OK_STATUS;
                }
            });
            start = end;
        }
    }

    private static void createCpuEntriesWithQuark(@NonNull ITmfTrace trace, ITmfStateSystem ssq, Map<Integer, ResourcesEntry> entryMap, TimeGraphEntry traceEntry, long startTime, long endTime, List<Integer> cpuQuarks) {
        for (Integer cpuQuark : cpuQuarks) {
            @NonNull String cpuName = ssq.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            ResourcesEntry cpuEntry = entryMap.get(cpuQuark);
            if (cpuEntry == null) {
                cpuEntry = new ResourcesEntry(cpuQuark, trace, startTime, endTime, ResourcesEntry.Type.CPU, cpu);
                entryMap.put(cpuQuark, cpuEntry);
                traceEntry.addChild((TimeGraphEntry)cpuEntry);
            } else {
                cpuEntry.updateEndTime(endTime);
            }
            List irqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "IRQs", "*"});
            ResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, entryMap, startTime, endTime, traceEntry, cpuEntry, irqQuarks, ResourcesEntry.Type.IRQ);
            List softIrqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "Soft_IRQs", "*"});
            ResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, entryMap, startTime, endTime, traceEntry, cpuEntry, softIrqQuarks, ResourcesEntry.Type.SOFT_IRQ);
        }
    }

    private static void createCpuInterruptEntryWithQuark(@NonNull ITmfTrace trace, ITmfStateSystem ssq, Map<Integer, ResourcesEntry> entryMap, long startTime, long endTime, TimeGraphEntry traceEntry, ResourcesEntry cpuEntry, List<Integer> childrenQuarks, ResourcesEntry.Type type) {
        for (Integer quark : childrenQuarks) {
            @NonNull String resourceName = ssq.getAttributeName(quark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            ResourcesEntry interruptEntry = entryMap.get(quark);
            if (interruptEntry == null) {
                interruptEntry = new ResourcesEntry(quark, trace, startTime, endTime, type, resourceId);
                entryMap.put(quark, interruptEntry);
                cpuEntry.addChild(interruptEntry);
                boolean found = false;
                for (ITimeGraphEntry rootElem : traceEntry.getChildren()) {
                    AggregateResourcesEntry aggregateInterruptEntry;
                    if (!(rootElem instanceof AggregateResourcesEntry) || (aggregateInterruptEntry = (AggregateResourcesEntry)rootElem).getId() != resourceId || !aggregateInterruptEntry.getType().equals((Object)type)) continue;
                    found = true;
                    aggregateInterruptEntry.addContributor((ITimeGraphEntry)interruptEntry);
                    AggregateResourcesEntry irqCpuEntry = new AggregateResourcesEntry(trace, cpuEntry.getName(), startTime, endTime, type, cpuEntry.getId());
                    irqCpuEntry.addContributor((ITimeGraphEntry)interruptEntry);
                    aggregateInterruptEntry.addChild(irqCpuEntry);
                    break;
                }
                if (found) continue;
                AggregateResourcesEntry aggregateInterruptEntry = new AggregateResourcesEntry(trace, startTime, endTime, type, resourceId);
                aggregateInterruptEntry.addContributor((ITimeGraphEntry)interruptEntry);
                AggregateResourcesEntry irqCpuEntry = new AggregateResourcesEntry(trace, cpuEntry.getName(), startTime, endTime, type, cpuEntry.getId());
                irqCpuEntry.addContributor((ITimeGraphEntry)interruptEntry);
                aggregateInterruptEntry.addChild(irqCpuEntry);
                traceEntry.addChild((TimeGraphEntry)aggregateInterruptEntry);
                continue;
            }
            interruptEntry.updateEndTime(endTime);
        }
    }

    protected @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, ITmfStateSystem ssq, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        ResourcesEntry resourcesEntry = (ResourcesEntry)entry;
        int quark = resourcesEntry.getQuark();
        if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
            return ResourcesView.createCpuEventsList((ITimeGraphEntry)entry, fullStates, prevFullState, monitor, quark);
        }
        if ((resourcesEntry.getType().equals((Object)ResourcesEntry.Type.IRQ) || resourcesEntry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) && quark >= 0) {
            return ResourcesView.createIrqEventsList((ITimeGraphEntry)entry, fullStates, prevFullState, monitor, quark);
        }
        return null;
    }

    private static List<ITimeEvent> createCpuEventsList(ITimeGraphEntry entry, List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState, IProgressMonitor monitor, int quark) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        ArrayList<ITimeEvent> eventList = new ArrayList<ITimeEvent>(fullStates.size());
        ITmfStateInterval lastInterval = prevFullState == null || quark >= prevFullState.size() ? null : prevFullState.get(quark);
        long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
        long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
        for (List<ITmfStateInterval> fullState : fullStates) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (quark >= fullState.size()) continue;
            ITmfStateInterval statusInterval = fullState.get(quark);
            int status = statusInterval.getStateValue().unboxInt();
            long time = statusInterval.getStartTime();
            long duration = statusInterval.getEndTime() - time + 1L;
            if (time == lastStartTime) continue;
            if (!statusInterval.getStateValue().isNull()) {
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add((ITimeEvent)new TimeEvent(entry, lastEndTime, time - lastEndTime));
                }
                eventList.add((ITimeEvent)new TimeEvent(entry, time, duration, status));
            } else if (isZoomThread) {
                eventList.add((ITimeEvent)new NullTimeEvent(entry, time, duration));
            }
            lastStartTime = time;
            lastEndTime = time + duration;
        }
        return eventList;
    }

    private static List<ITimeEvent> createIrqEventsList(ITimeGraphEntry entry, List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState, IProgressMonitor monitor, int quark) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        ArrayList<ITimeEvent> eventList = new ArrayList<ITimeEvent>(fullStates.size());
        ITmfStateInterval lastInterval = prevFullState == null || quark >= prevFullState.size() ? null : prevFullState.get(quark);
        long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
        long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
        boolean lastIsNull = lastInterval == null ? false : lastInterval.getStateValue().isNull();
        for (List<ITmfStateInterval> fullState : fullStates) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (quark >= fullState.size()) continue;
            ITmfStateInterval irqInterval = fullState.get(quark);
            long time = irqInterval.getStartTime();
            long duration = irqInterval.getEndTime() - time + 1L;
            if (time == lastStartTime) continue;
            if (!irqInterval.getStateValue().isNull()) {
                int cpu = irqInterval.getStateValue().unboxInt();
                eventList.add((ITimeEvent)new TimeEvent(entry, time, duration, cpu));
                lastIsNull = false;
            } else {
                if (lastEndTime != time && lastIsNull) {
                    eventList.add((ITimeEvent)new TimeEvent(entry, lastEndTime, time - lastEndTime, -1));
                }
                if (isZoomThread) {
                    eventList.add((ITimeEvent)new NullTimeEvent(entry, time, duration));
                }
                lastIsNull = true;
            }
            lastStartTime = time;
            lastEndTime = time + duration;
        }
        return eventList;
    }

    @TmfSignalHandler
    public void listenToCpu(TmfCpuSelectedSignal signal) {
        int data = signal.getCore() >= 0 ? signal.getCore() : -1;
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        ctx.setData(RESOURCES_FOLLOW_CPU, (Object)data);
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            ResourcesEntry entry1 = (ResourcesEntry)o1;
            ResourcesEntry entry2 = (ResourcesEntry)o2;
            if (entry1.getType() == ResourcesEntry.Type.NULL && entry2.getType() == ResourcesEntry.Type.NULL) {
                return entry1.getName().compareTo(entry2.getName());
            }
            return entry1.compareTo((ITimeGraphEntry)entry2);
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ResourcesEntry entry = (ResourcesEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }
}

