/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class SegmentStoreStatistics {
    private ISegment fMin = new BasicSegment(0L, Long.MAX_VALUE);
    private ISegment fMax = new BasicSegment(Long.MIN_VALUE, 0L);
    private long fNbSegments = 0L;
    private double fAverage = 0.0;
    private double fVariance = 0.0;
    private double fTotal = 0.0;

    public long getMin() {
        return this.fMin.getLength();
    }

    public long getMax() {
        return this.fMax.getLength();
    }

    public ISegment getMinSegment() {
        return this.fMin;
    }

    public ISegment getMaxSegment() {
        return this.fMax;
    }

    public long getNbSegments() {
        return this.fNbSegments;
    }

    public double getAverage() {
        return this.fAverage;
    }

    public double getStdDev() {
        return this.fNbSegments > 2L ? Math.sqrt(this.fVariance / (double)(this.fNbSegments - 1L)) : Double.NaN;
    }

    public double getTotal() {
        return this.fTotal;
    }

    public void update(ISegment segment) {
        long value = segment.getLength();
        long min = this.fMin.getLength();
        long max = this.fMax.getLength();
        this.fMin = min <= value ? this.fMin : segment;
        this.fMax = max >= value ? this.fMax : segment;
        ++this.fNbSegments;
        double delta = (double)value - this.fAverage;
        this.fAverage += delta / (double)this.fNbSegments;
        this.fVariance += delta * ((double)value - this.fAverage);
        this.fTotal += (double)value;
    }

    public void merge(SegmentStoreStatistics other) {
        if (other.fNbSegments == 0L) {
            return;
        }
        if (this.fNbSegments == 0L) {
            this.copy(other);
        } else if (other.fNbSegments == 1L) {
            this.update(other.fMax);
        } else if (this.fNbSegments == 1L) {
            SegmentStoreStatistics copyOther = new SegmentStoreStatistics();
            copyOther.copy(other);
            copyOther.update(this.fMax);
            this.copy(copyOther);
        } else {
            this.internalMerge(other);
        }
    }

    private void internalMerge(SegmentStoreStatistics other) {
        long min = this.fMin.getLength();
        long max = this.fMax.getLength();
        this.fMin = min <= other.getMin() ? this.fMin : other.getMinSegment();
        this.fMax = max >= other.getMax() ? this.fMax : other.getMaxSegment();
        long oldNbSeg = this.fNbSegments;
        double oldAverage = this.fAverage;
        long otherSegments = other.getNbSegments();
        double otherAverage = other.getAverage();
        this.fNbSegments += otherSegments;
        this.fTotal += other.getTotal();
        this.fAverage = ((double)oldNbSeg * oldAverage + otherAverage * (double)otherSegments) / (double)this.fNbSegments;
        double avg1Sq = oldAverage * oldAverage;
        double avg2sq = otherAverage * otherAverage;
        double avgtSq = this.fAverage * this.fAverage;
        double variance1 = this.fVariance / (double)(oldNbSeg - 1L);
        double variance2 = other.fVariance / (double)(otherSegments - 1L);
        this.fVariance = (variance1 + avg1Sq - avgtSq) * (double)(oldNbSeg - 1L) + (variance2 + avg2sq - avgtSq) * (double)(otherSegments - 1L);
    }

    private void copy(SegmentStoreStatistics copyOther) {
        this.fAverage = copyOther.fAverage;
        this.fMax = copyOther.fMax;
        this.fMin = copyOther.fMin;
        this.fNbSegments = copyOther.fNbSegments;
        this.fTotal = copyOther.fTotal;
        this.fVariance = copyOther.fVariance;
    }
}

