/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.internal.contentproperties;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.internal.contentproperties.AbstractContentSettingsHandler;

class ContentSettingsFileHandler
extends AbstractContentSettingsHandler {
    private Map properties;

    ContentSettingsFileHandler() {
    }

    private void getProperties(IResource file) {
        this.properties = this.getContentSettings().getProperties(file);
    }

    protected void handleAdded() {
        super.handleAdded();
        if (super.getDelta().getFlags() != 0) {
            this.getDelta().getFlags();
        }
    }

    protected void handleChanged() {
        if (this.getDelta().getFlags() == 256 && (this.getDelta().getFlags() & 0x40000) == 0) {
            super.handleChanged();
        } else if (this.getDelta().getFlags() == 256 && (this.getDelta().getFlags() & 0x40000) != 0) {
            super.handleChanged();
        }
    }

    protected void handleRemoved() {
        super.handleRemoved();
        IFile deletedFile = null;
        if (this.getDelta().getFlags() == 0) {
            deletedFile = (IFile)this.getDelta().getResource();
            if (deletedFile == null) {
                return;
            }
            this.getContentSettings().deleteAllProperties((IResource)deletedFile);
            this.getContentSettings().releaseCache();
        } else if ((this.getDelta().getFlags() & 0x2000) != 0) {
            deletedFile = (IFile)this.getDelta().getResource();
            this.getProperties((IResource)deletedFile);
            IPath targetPath = this.getDelta().getMovedToPath();
            IWorkspaceRoot iwr = ResourcesPlugin.getWorkspace().getRoot();
            IFile targetFile = iwr.getFile(targetPath);
            this.getContentSettings().deleteAllProperties((IResource)targetFile);
            this.setProperties((IResource)targetFile);
            if (this.properties != null) {
                this.properties.clear();
            }
            this.properties = null;
        }
        if (deletedFile == null) {
            return;
        }
        this.getContentSettings().deleteAllProperties((IResource)deletedFile);
        this.getContentSettings().releaseCache();
    }

    private void setProperties(IResource file) {
        if (file.getFileExtension() == null) {
            return;
        }
        if (!(file.getFileExtension().equalsIgnoreCase("shtml") || file.getFileExtension().equalsIgnoreCase("htm") || file.getFileExtension().equalsIgnoreCase("html") || file.getFileExtension().equalsIgnoreCase("jhtml") || file.getFileExtension().equalsIgnoreCase("xhtml") || file.getFileExtension().equalsIgnoreCase("jsp") || file.getFileExtension().equalsIgnoreCase("css") || file.getFileExtension().equalsIgnoreCase("jsf") || file.getFileExtension().equalsIgnoreCase("jspf"))) {
            return;
        }
        if (this.properties == null || this.properties.isEmpty()) {
            return;
        }
        this.getContentSettings().setProperties(file, this.properties);
    }
}

