/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.graph;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.tests.Activator;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.module.GraphBuilderModuleStub;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.Assert;
import org.junit.Test;

public class TmfGraphBuilderModuleTest {
    private static final String STUB_TRACE_FILE = "testfiles/stubtrace.xml";

    private TmfGraphBuilderModule getModule() {
        TmfXmlTraceStub trace = TmfXmlTraceStub.setupTrace((IPath)Activator.getAbsoluteFilePath(STUB_TRACE_FILE));
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        GraphBuilderModuleStub module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, GraphBuilderModuleStub.class).iterator();
        while (iterator.hasNext()) {
            GraphBuilderModuleStub mod;
            module = mod = (GraphBuilderModuleStub)((Object)iterator.next());
        }
        Assert.assertNotNull(module);
        return module;
    }

    @Test
    public void testBuildGraph() {
        TmfGraphBuilderModule module = this.getModule();
        module.schedule();
        module.waitForCompletion();
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Assert.assertEquals((long)2L, (long)graph.getWorkers().size());
        Assert.assertEquals((long)9L, (long)graph.size());
        List vertices = graph.getNodesOf((IGraphWorker)new TestGraphWorker(1));
        Assert.assertEquals((long)5L, (long)vertices.size());
        long[] timestamps1 = new long[]{1L, 2L, 5L, 7L, 12L};
        boolean[][] blArrayArray = new boolean[5][];
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[3] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[4];
        blArray3[1] = true;
        blArray3[2] = true;
        blArrayArray[2] = blArray3;
        boolean[] blArray4 = new boolean[4];
        blArray4[0] = true;
        blArrayArray[3] = blArray4;
        boolean[] blArray5 = new boolean[4];
        blArray5[2] = true;
        blArrayArray[4] = blArray5;
        boolean[][] hasEdges1 = blArrayArray;
        int i = 0;
        while (i < vertices.size()) {
            TmfVertex v = (TmfVertex)vertices.get(i);
            Assert.assertEquals((long)timestamps1[i], (long)v.getTs());
            Assert.assertEquals((Object)hasEdges1[i][0], (Object)(v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges1[i][1], (Object)(v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges1[i][2], (Object)(v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges1[i][3], (Object)(v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE) != null ? 1 : 0));
            ++i;
        }
        vertices = graph.getNodesOf((IGraphWorker)new TestGraphWorker(2));
        Assert.assertEquals((long)4L, (long)vertices.size());
        long[] timestamps2 = new long[]{2L, 5L, 10L, 12L};
        boolean[][] blArrayArray2 = new boolean[4][];
        boolean[] blArray6 = new boolean[4];
        blArray6[1] = true;
        blArray6[2] = true;
        blArrayArray2[0] = blArray6;
        boolean[] blArray7 = new boolean[4];
        blArray7[0] = true;
        blArray7[3] = true;
        blArrayArray2[1] = blArray7;
        boolean[] blArray8 = new boolean[4];
        blArray8[1] = true;
        blArrayArray2[2] = blArray8;
        boolean[] blArray9 = new boolean[4];
        blArray9[0] = true;
        blArray9[3] = true;
        blArrayArray2[3] = blArray9;
        boolean[][] hasEdges2 = blArrayArray2;
        int i2 = 0;
        while (i2 < vertices.size()) {
            TmfVertex v = (TmfVertex)vertices.get(i2);
            Assert.assertEquals((long)timestamps2[i2], (long)v.getTs());
            Assert.assertEquals((Object)hasEdges2[i2][0], (Object)(v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges2[i2][1], (Object)(v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges2[i2][2], (Object)(v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE) != null ? 1 : 0));
            Assert.assertEquals((Object)hasEdges2[i2][3], (Object)(v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE) != null ? 1 : 0));
            ++i2;
        }
    }
}

