/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.lami.core.tests;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;

public class LamiAnalysisStub
extends LamiAnalysis {
    private final String fMetaDatafilename;
    private final String fResultFilename;

    protected LamiAnalysisStub(String metaDatafilename, String resultFilename) {
        super("Stub Analysis", false, o -> true, Collections.singletonList("StubExecutable"));
        this.fMetaDatafilename = metaDatafilename;
        this.fResultFilename = resultFilename;
    }

    public @NonNull String getName() {
        return "StubName";
    }

    protected @NonNull Multimap<@NonNull String, @NonNull LamiChartModel> getPredefinedCharts() {
        return ImmutableMultimap.of();
    }

    protected String getResultsFromCommand(List<String> command, IProgressMonitor monitor) throws CoreException {
        return LamiAnalysisStub.readLamiFile(this.fResultFilename);
    }

    protected @Nullable String getOutputFromCommand(List<String> command) {
        return LamiAnalysisStub.readLamiFile(this.fMetaDatafilename);
    }

    public boolean canExecute(ITmfTrace trace) {
        this.initialize();
        return true;
    }

    protected synchronized void initialize() {
        this.checkMetadata();
    }

    private static String readLamiFile(String filename) {
        String fileContent = "";
        try {
            URL url = new URL("platform:/plugin/org.eclipse.tracecompass.analysis.lami.core.tests/testfiles/" + filename);
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = url.openConnection().getInputStream();){
                BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                fileContent = in.lines().collect(Collectors.joining());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        return fileContent;
    }
}

