/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.lami.core.tests;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tracecompass.analysis.lami.core.tests.LamiAnalysisStub;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiBitrate;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDuration;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiSize;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiSystemCall;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LamiJsonParserTest {
    private static final double DELTA = 0.001;
    private static final String TRACEPATH = "fake/path/to/trace";
    private LamiTmfTraceStub fTrace;

    @Before
    public void setup() {
        this.fTrace = new LamiTmfTraceStub();
    }

    @After
    public void teardown() {
        this.fTrace.dispose();
    }

    @Test
    public void testMetadata() {
        LamiAnalysisStub analysis = new LamiAnalysisStub("test-metadata.json", "test-results.json");
        Assert.assertTrue((boolean)analysis.canExecute((ITmfTrace)this.fTrace));
        Assert.assertEquals((Object)"LAMI test", (Object)analysis.getAnalysisTitle());
        Map tableModels = analysis.getTableClasses();
        Assert.assertNotNull((Object)tableModels);
        Assert.assertFalse((boolean)tableModels.isEmpty());
        Assert.assertEquals((long)3L, (long)tableModels.size());
        LamiTableClass perSyscallClass = (LamiTableClass)tableModels.get("per-syscall");
        Assert.assertNotNull((Object)perSyscallClass);
        LamiTableClass perProcessClass = (LamiTableClass)tableModels.get("per-proc");
        Assert.assertNotNull((Object)perProcessClass);
        LamiTableClass perInterruptClass = (LamiTableClass)tableModels.get("per-irq");
        Assert.assertNotNull((Object)perInterruptClass);
        Assert.assertEquals((Object)"Per-syscall stuff", (Object)perSyscallClass.getTableTitle());
        Assert.assertEquals((Object)"Per-process stuff", (Object)perProcessClass.getTableTitle());
        Assert.assertEquals((Object)"Per-interrupt stuff", (Object)perInterruptClass.getTableTitle());
        List aspects = perSyscallClass.getAspects();
        Assert.assertFalse((boolean)aspects.isEmpty());
        Assert.assertEquals((long)8L, (long)aspects.size());
        Assert.assertEquals((Object)"System call", (Object)((LamiTableEntryAspect)aspects.get(0)).getLabel());
        Assert.assertEquals((Object)"Duration (ns)", (Object)((LamiTableEntryAspect)aspects.get(1)).getLabel());
        Assert.assertEquals((Object)"Size (bytes)", (Object)((LamiTableEntryAspect)aspects.get(2)).getLabel());
        Assert.assertEquals((Object)"Bitrate (bps)", (Object)((LamiTableEntryAspect)aspects.get(3)).getLabel());
        Assert.assertEquals((Object)"Time range (begin)", (Object)((LamiTableEntryAspect)aspects.get(4)).getLabel());
        Assert.assertEquals((Object)"Time range (end)", (Object)((LamiTableEntryAspect)aspects.get(5)).getLabel());
        Assert.assertEquals((Object)"Time range (duration) (ns)", (Object)((LamiTableEntryAspect)aspects.get(6)).getLabel());
        Assert.assertEquals((Object)"", (Object)((LamiTableEntryAspect)aspects.get(7)).getLabel());
    }

    @Test
    public void testResults() throws CoreException {
        LamiAnalysisStub analysis = new LamiAnalysisStub("test-metadata.json", "test-results.json");
        List resultTables = analysis.execute((ITmfTrace)this.fTrace, null, "", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)resultTables.isEmpty());
        Assert.assertEquals((long)4L, (long)resultTables.size());
        LamiResultTable perProcessTable = (LamiResultTable)resultTables.get(0);
        LamiResultTable perSyscallTable = (LamiResultTable)resultTables.get(1);
        LamiResultTable perInterruptTable = (LamiResultTable)resultTables.get(2);
        LamiResultTable perInterruptOverrideTable = (LamiResultTable)resultTables.get(3);
        Assert.assertEquals((Object)"Per-process stuff", (Object)perProcessTable.getTableClass().getTableTitle());
        Assert.assertEquals((Object)"per-proc", (Object)perProcessTable.getTableClass().getTableClassName());
        Assert.assertEquals((Object)"Per-syscall stuff", (Object)perSyscallTable.getTableClass().getTableTitle());
        Assert.assertEquals((Object)"per-syscall", (Object)perSyscallTable.getTableClass().getTableClassName());
        Assert.assertEquals((Object)"Per-interrupt stuff", (Object)perInterruptTable.getTableClass().getTableTitle());
        Assert.assertEquals((Object)"per-irq", (Object)perInterruptTable.getTableClass().getTableClassName());
        Assert.assertEquals((Object)"Per-interrupt stuff [with overridden title]", (Object)perInterruptOverrideTable.getTableClass().getTableTitle());
        Assert.assertEquals((Object)"Extended per-irq", (Object)perInterruptOverrideTable.getTableClass().getTableClassName());
        LamiTimeRange expectedTimeRange = new LamiTimeRange(new LamiTimestamp(1000L), new LamiTimestamp(2000L));
        Assert.assertEquals((Object)expectedTimeRange, (Object)perProcessTable.getTimeRange());
        List syscallEntries = perSyscallTable.getEntries();
        Assert.assertFalse((boolean)syscallEntries.isEmpty());
        Assert.assertEquals((long)5L, (long)syscallEntries.size());
        LamiTableEntry readEntry = (LamiTableEntry)syscallEntries.get(0);
        LamiTimeRange readEntryTimeRange = readEntry.getCorrespondingTimeRange();
        expectedTimeRange = new LamiTimeRange(new LamiTimestamp(98233L), new LamiTimestamp(1293828L));
        Assert.assertNotNull((Object)readEntryTimeRange);
        Assert.assertEquals((Object)expectedTimeRange, (Object)readEntryTimeRange);
        LamiData value0 = readEntry.getValue(0);
        Assert.assertTrue((boolean)(value0 instanceof LamiSystemCall));
        Assert.assertEquals((Object)"read", (Object)((LamiSystemCall)value0).getValue());
        LamiData value1 = readEntry.getValue(1);
        Assert.assertTrue((boolean)(value1 instanceof LamiDuration));
        Assert.assertEquals((Object)new LamiDuration(2398123L), (Object)value1);
        LamiData value2 = readEntry.getValue(2);
        Assert.assertTrue((boolean)(value2 instanceof LamiSize));
        Assert.assertEquals((Object)new LamiSize(8123982L), (Object)value2);
        LamiData value3 = readEntry.getValue(3);
        Assert.assertTrue((boolean)(value3 instanceof LamiBitrate));
        Assert.assertEquals((Object)new LamiBitrate(223232.0), (Object)value3);
        LamiData value4 = readEntry.getValue(4);
        expectedTimeRange = new LamiTimeRange(new LamiTimestamp(98233L), new LamiTimestamp(1293828L));
        Assert.assertTrue((boolean)(value4 instanceof LamiTimeRange));
        Assert.assertEquals((Object)expectedTimeRange, (Object)value4);
        Map tableModels = analysis.getTableClasses();
        Assert.assertNotNull((Object)tableModels);
        LamiTableClass perSyscallClass = (LamiTableClass)tableModels.get("per-syscall");
        Assert.assertNotNull((Object)perSyscallClass);
        List aspects = perSyscallClass.getAspects();
        Assert.assertEquals((Object)"read()", (Object)((LamiTableEntryAspect)aspects.get(0)).resolveString(readEntry));
        Assert.assertEquals((double)2398123.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(1)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertEquals((double)8123982.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(2)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertEquals((double)223232.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(3)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertEquals((double)98233.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(4)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertEquals((double)1293828.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(5)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertEquals((double)1195595.0, (double)((Number)NonNullUtils.checkNotNull((Object)((LamiTableEntryAspect)aspects.get(6)).resolveNumber(readEntry))).doubleValue(), (double)0.001);
        Assert.assertNull((Object)((LamiTableEntryAspect)aspects.get(7)).resolveString(readEntry));
    }

    @Test(expected=CoreException.class)
    public void testResultsError() throws CoreException {
        LamiAnalysisStub analysis = new LamiAnalysisStub("test-metadata.json", "test-error.json");
        analysis.execute((ITmfTrace)this.fTrace, null, "", (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testBaseCommand() {
        LamiAnalysisStub analysis = new LamiAnalysisStub("test-metadata.json", "test-error.json");
        ITmfTimestamp begin = TmfTimestamp.fromNanos((long)98233L);
        ITmfTimestamp end = TmfTimestamp.fromNanos((long)1293828L);
        TmfTimeRange timerange = new TmfTimeRange(begin, end);
        Assert.assertEquals((Object)"StubExecutable \"fake/path/to/trace\"", (Object)analysis.getFullCommandAsString((ITmfTrace)this.fTrace, null));
        Assert.assertEquals((Object)"StubExecutable --begin 98233 --end 1293828 \"fake/path/to/trace\"", (Object)analysis.getFullCommandAsString((ITmfTrace)this.fTrace, timerange));
    }

    private static class LamiTmfTraceStub
    extends TmfTraceStub {
        private LamiTmfTraceStub() {
        }

        public String getPath() {
            return LamiJsonParserTest.TRACEPATH;
        }
    }
}

