/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiIRQ;

public class LamiIRQNumberAspect
extends LamiTableEntryAspect {
    private final int fColIndex;

    public LamiIRQNumberAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (#)", null);
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isTimeStamp() {
        return false;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiIRQ) {
            return String.valueOf(((LamiIRQ)data).getNumber());
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiIRQ) {
            return ((LamiIRQ)data).getNumber();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return (o1, o2) -> {
            Number d1 = this.resolveNumber((LamiTableEntry)o1);
            Number d2 = this.resolveNumber((LamiTableEntry)o2);
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return Integer.compare(d1.intValue(), d2.intValue());
        };
    }
}

