/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiXYSeriesDescription;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiAxisCheckBoxOption;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;
import org.eclipse.ui.dialogs.SelectionDialog;

public class LamiSeriesDialog
extends SelectionDialog {
    private static final int MINIMUM_COLUMN_WIDTH = 30;
    private static final int MININAL_SERIES_TABLE_HEIGHT = 150;
    private final Object fXInputElement;
    private final Object fYInputElement;
    private final List<LamiXYSeriesDescription> series;
    private final ILabelProvider fXLabelProvider;
    private final IStructuredContentProvider fXContentProvider;
    private final ILabelProvider fYLabelProvider;
    private final IStructuredContentProvider fYContentProvider;
    private final IStructuredContentProvider fSeriesContentProvider;
    private final boolean fRestrictXSeriesNumbers;
    private final List<LamiAxisCheckBoxOption> fXCheckBoxOptions;
    private final List<LamiAxisCheckBoxOption> fYCheckBoxOptions;
    private TableViewer fXTableViewer;
    private CheckboxTableViewer fYCheckBoxViewer;
    private TableViewer fSeriesListViewer;
    private Label fWarning;

    public LamiSeriesDialog(Shell parentShell, LamiChartModel.ChartType chartType, Object xInput, Object yInput, IStructuredContentProvider xContentProvider, ILabelProvider xLabelProvider, IStructuredContentProvider yContentProvider, ILabelProvider yLabelProvider) {
        super(parentShell);
        this.fXInputElement = xInput;
        this.fYInputElement = yInput;
        this.fXContentProvider = xContentProvider;
        this.fXLabelProvider = xLabelProvider;
        this.fYContentProvider = yContentProvider;
        this.fYLabelProvider = yLabelProvider;
        this.series = new ArrayList<LamiXYSeriesDescription>();
        this.fSeriesContentProvider = (IStructuredContentProvider)NonNullUtils.checkNotNull((Object)ArrayContentProvider.getInstance());
        this.fXCheckBoxOptions = new ArrayList<LamiAxisCheckBoxOption>();
        this.fYCheckBoxOptions = new ArrayList<LamiAxisCheckBoxOption>();
        this.fSeriesListViewer = new TableViewer((Composite)parentShell);
        this.fXTableViewer = new TableViewer((Composite)parentShell);
        this.fYCheckBoxViewer = (CheckboxTableViewer)NonNullUtils.checkNotNull((Object)CheckboxTableViewer.newCheckList((Composite)parentShell, (int)0));
        switch (chartType) {
            case XY_SCATTER: {
                this.fRestrictXSeriesNumbers = false;
                break;
            }
            default: {
                this.fRestrictXSeriesNumbers = true;
            }
        }
        this.fWarning = new Label((Composite)parentShell, 0);
    }

    protected Control createDialogArea(@Nullable Composite parent) {
        Button button;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        Group seriesGroup = new Group(composite, 0);
        seriesGroup.setLayoutData((Object)gridData);
        seriesGroup.setLayout((Layout)new GridLayout(3, false));
        seriesGroup.setText(Messages.LamiSeriesDialog_series);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        Group seriesTableGroup = new Group((Composite)seriesGroup, 0);
        seriesTableGroup.setLayoutData((Object)gridData);
        TableColumnLayout layout = new TableColumnLayout();
        seriesTableGroup.setLayout((Layout)layout);
        this.fSeriesListViewer = new TableViewer((Composite)seriesTableGroup, 2818);
        this.fSeriesListViewer.setContentProvider((IContentProvider)this.fSeriesContentProvider);
        this.fSeriesListViewer.setInput(this.series);
        this.fSeriesListViewer.getTable().setHeaderVisible(true);
        this.fSeriesListViewer.getTable().setLinesVisible(true);
        TableViewerColumn column1 = LamiSeriesDialog.createTableViewerColumn(this.fSeriesListViewer, Messages.LamiSeriesDialog_x_values, element -> element.getXAspect().getLabel());
        TableViewerColumn column2 = LamiSeriesDialog.createTableViewerColumn(this.fSeriesListViewer, Messages.LamiSeriesDialog_y_values, element -> element.getYAspect().getLabel());
        layout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 30, true));
        layout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 30, true));
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        Button deleteSeries = new Button((Composite)seriesGroup, 8);
        deleteSeries.setText(Messages.LamiSeriesDialog_delete);
        deleteSeries.setLayoutData((Object)gridData);
        deleteSeries.addSelectionListener(new SelectionListener(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                IStructuredSelection selections = (IStructuredSelection)LamiSeriesDialog.this.fSeriesListViewer.getSelection();
                for (Object selection : selections.toList()) {
                    LamiSeriesDialog.this.series.remove(selection);
                }
                if (LamiSeriesDialog.this.series.isEmpty()) {
                    LamiSeriesDialog.this.getButton(0).setEnabled(false);
                    LamiSeriesDialog.this.fWarning.setVisible(false);
                    LamiSeriesDialog.this.fXTableViewer.refresh();
                    LamiSeriesDialog.this.fXCheckBoxOptions.forEach(checkBox -> checkBox.setButtonEnabled(true));
                    LamiSeriesDialog.this.fYCheckBoxOptions.forEach(checkBox -> checkBox.setButtonEnabled(true));
                }
                LamiSeriesDialog.this.fSeriesListViewer.refresh();
            }

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
            }
        });
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        Group seriesCreatorGroup = new Group(composite, this.getShellStyle());
        seriesCreatorGroup.setLayoutData((Object)gridData);
        seriesCreatorGroup.setLayout((Layout)new GridLayout(3, false));
        seriesCreatorGroup.setText(Messages.LamiSeriesDialog_serie_creator);
        gridData = new GridData(1816);
        gridData.horizontalSpan = 1;
        Label xSeriesCreatorLabel = new Label((Composite)seriesCreatorGroup, 0x1000000);
        xSeriesCreatorLabel.setLayoutData((Object)gridData);
        xSeriesCreatorLabel.setText(Messages.LamiSeriesDialog_x_axis);
        gridData = new GridData(1816);
        gridData.horizontalSpan = 1;
        Label ySeriesCreatorLabel = new Label((Composite)seriesCreatorGroup, 0x1000000);
        ySeriesCreatorLabel.setLayoutData((Object)gridData);
        ySeriesCreatorLabel.setText(Messages.LamiSeriesDialog_y_axis);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        Label emptyLabel = new Label((Composite)seriesCreatorGroup, 0x1000000);
        emptyLabel.setLayoutData((Object)gridData);
        SashForm sash1 = new SashForm((Composite)seriesCreatorGroup, 2304);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        sash1.setLayoutData((Object)gridData);
        sash1.setVisible(true);
        this.fXTableViewer = new TableViewer((Composite)sash1, this.getTableStyle());
        this.fXTableViewer.setContentProvider((IContentProvider)this.fXContentProvider);
        this.fXTableViewer.setLabelProvider((IBaseLabelProvider)this.fXLabelProvider);
        this.fXTableViewer.setInput(this.fXInputElement);
        this.fYCheckBoxViewer = (CheckboxTableViewer)NonNullUtils.checkNotNull((Object)CheckboxTableViewer.newCheckList((Composite)sash1, (int)2048));
        this.fYCheckBoxViewer.setLabelProvider((IBaseLabelProvider)this.fYLabelProvider);
        this.fYCheckBoxViewer.setContentProvider((IContentProvider)this.fYContentProvider);
        this.fYCheckBoxViewer.setInput(this.fYInputElement);
        gridData = new GridData(4, 0, true, true);
        gridData.horizontalSpan = 1;
        Button button1 = new Button((Composite)seriesCreatorGroup, 8);
        button1.setText(Messages.LamiSeriesDialog_add);
        button1.setLayoutData((Object)gridData);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                Object[] ySelections = LamiSeriesDialog.this.fYCheckBoxViewer.getCheckedElements();
                IStructuredSelection xSelections = (IStructuredSelection)LamiSeriesDialog.this.fXTableViewer.getSelection();
                @Nullable Object x = xSelections.getFirstElement();
                if (!(x instanceof LamiTableEntryAspect) || ySelections.length == 0) {
                    return;
                }
                Object[] objectArray = ySelections;
                int n = ySelections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object y = objectArray[n2];
                    if (y instanceof LamiTableEntryAspect) {
                        LamiXYSeriesDescription serie = new LamiXYSeriesDescription((LamiTableEntryAspect)x, (LamiTableEntryAspect)y);
                        if (!LamiSeriesDialog.this.series.contains(serie)) {
                            LamiSeriesDialog.this.series.add(serie);
                            LamiSeriesDialog.this.fSeriesListViewer.refresh();
                        }
                    }
                    ++n2;
                }
                LamiSeriesDialog.this.fWarning.setVisible(true);
                LamiSeriesDialog.this.getButton(0).setEnabled(true);
                TableItem[] items = LamiSeriesDialog.this.fXTableViewer.getTable().getItems();
                Arrays.stream(items).forEach(item -> {
                    LamiTableEntryAspect aspect = (LamiTableEntryAspect)item.getData();
                    if (!aspect.arePropertiesEqual(((LamiXYSeriesDescription)LamiSeriesDialog.this.series.get(0)).getXAspect())) {
                        LamiSeriesDialog.this.fXTableViewer.remove((Object)aspect);
                    }
                    if (LamiSeriesDialog.this.fRestrictXSeriesNumbers && aspect != ((LamiXYSeriesDescription)LamiSeriesDialog.this.series.get(0)).getXAspect()) {
                        LamiSeriesDialog.this.fXTableViewer.remove((Object)aspect);
                    }
                });
                LamiSeriesDialog.this.fXCheckBoxOptions.forEach(checkBox -> checkBox.setButtonEnabled(checkBox.getPredicate().test(((LamiXYSeriesDescription)LamiSeriesDialog.this.series.get(0)).getXAspect())));
                LamiSeriesDialog.this.fYCheckBoxOptions.forEach(checkBox -> checkBox.setButtonEnabled(checkBox.getPredicate().test(((LamiXYSeriesDescription)LamiSeriesDialog.this.series.get(0)).getYAspect())));
            }

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
            }
        });
        gridData = new GridData(1816);
        gridData.horizontalSpan = 3;
        this.fWarning = new Label((Composite)seriesCreatorGroup, 16384);
        this.fWarning.setLayoutData((Object)gridData);
        this.fWarning.setText(Messages.LamiSeriesDialog_selectionRestrictionWarning);
        this.fWarning.setForeground(Display.getCurrent().getSystemColor(3));
        this.fWarning.setVisible(false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        Group optionGroups = new Group(composite, this.getShellStyle());
        optionGroups.setLayoutData((Object)gridData);
        optionGroups.setLayout((Layout)new GridLayout(3, false));
        optionGroups.setText(Messages.LamiSeriesDialog_chart_options);
        for (LamiAxisCheckBoxOption checkBox : this.fXCheckBoxOptions) {
            button = new Button((Composite)optionGroups, 32);
            button.setSelection(checkBox.getDefaultValue());
            button.setText(checkBox.getName());
            checkBox.setButton(button);
        }
        for (LamiAxisCheckBoxOption checkBox : this.fYCheckBoxOptions) {
            button = new Button((Composite)optionGroups, 32);
            button.setSelection(checkBox.getDefaultValue());
            button.setText(checkBox.getName());
            checkBox.setButton(button);
        }
        this.fYCheckBoxViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                IStructuredSelection selections;
                if (e != null && e.detail == 32 && (selections = (IStructuredSelection)LamiSeriesDialog.this.fYCheckBoxViewer.getSelection()).getFirstElement() != null) {
                    boolean checked = LamiSeriesDialog.this.fYCheckBoxViewer.getChecked(selections.getFirstElement());
                    if (checked) {
                        TableItem[] items = LamiSeriesDialog.this.fYCheckBoxViewer.getTable().getItems();
                        Arrays.stream(items).forEach(item -> {
                            LamiTableEntryAspect aspect = (LamiTableEntryAspect)item.getData();
                            if (!aspect.arePropertiesEqual((LamiTableEntryAspect)NonNullUtils.checkNotNull((Object)selections.getFirstElement()))) {
                                LamiSeriesDialog.this.fYCheckBoxViewer.remove((Object)aspect);
                            }
                        });
                    } else if (!checked && LamiSeriesDialog.this.fYCheckBoxViewer.getCheckedElements().length == 0 && LamiSeriesDialog.this.fSeriesListViewer.getTable().getItemCount() == 0) {
                        LamiSeriesDialog.this.fYCheckBoxViewer.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(@Nullable Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected int getTableStyle() {
        return 2820;
    }

    public int addXCheckBoxOption(String name, boolean defaultValue, Predicate<LamiTableEntryAspect> predicate) {
        LamiAxisCheckBoxOption checkBox = new LamiAxisCheckBoxOption(name, defaultValue, predicate);
        this.fXCheckBoxOptions.add(checkBox);
        return this.fXCheckBoxOptions.size() - 1;
    }

    public int addYCheckBoxOption(String name, boolean defaultValue, Predicate<LamiTableEntryAspect> predicate) {
        LamiAxisCheckBoxOption checkbox = new LamiAxisCheckBoxOption(name, defaultValue, predicate);
        this.fYCheckBoxOptions.add(checkbox);
        return this.fYCheckBoxOptions.size() - 1;
    }

    public boolean[] getXCheckBoxOptionValues() {
        boolean[] selections = new boolean[this.fXCheckBoxOptions.size()];
        int i = 0;
        while (i < selections.length) {
            selections[i] = this.fXCheckBoxOptions.get(i).getValue();
            ++i;
        }
        return selections;
    }

    public boolean[] getYCheckBoxOptionValues() {
        boolean[] selections = new boolean[this.fYCheckBoxOptions.size()];
        int i = 0;
        while (i < selections.length) {
            selections[i] = this.fYCheckBoxOptions.get(i).getValue();
            ++i;
        }
        return selections;
    }

    protected void okPressed() {
        for (LamiAxisCheckBoxOption checkBox : this.fXCheckBoxOptions) {
            checkBox.updateValue();
        }
        for (LamiAxisCheckBoxOption checkBox : this.fYCheckBoxOptions) {
            checkBox.updateValue();
        }
        super.okPressed();
    }

    public Object[] getResult() {
        return this.series.toArray();
    }

    private static <T extends Comparable<T>> TableViewerColumn createTableViewerColumn(TableViewer viewer, String name, final Function<LamiXYSeriesDescription, T> propertyFunction) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0x1000000);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(@Nullable Object element) {
                if (element != null) {
                    return ((Comparable)propertyFunction.apply((LamiXYSeriesDescription)element)).toString();
                }
                return null;
            }
        });
        TableColumn column = viewerColumn.getColumn();
        column.setText(name);
        return viewerColumn;
    }
}

