/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.latency;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentStoreStatisticsView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.latency.statistics.SystemCallLatencyStatisticsView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SystemCallLatencyStatisticsTableAnalysisTest {
    private static final int MIN_COL = 1;
    private static final int MAX_COL = 2;
    private static final int AVERAGE_COL = 3;
    private static final int STDEV_COL = 4;
    private static final int COUNT_COL = 5;
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String PROJECT_NAME = "test";
    private static final String VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.ui.views.latency.statsview";
    private static final String TRACING_PERSPECTIVE_ID = "org.eclipse.linuxtools.tmf.ui.perspective";
    private static final Logger fLogger = Logger.getRootLogger();
    private SWTBotTree fTreeBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        List openViews = bot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
            bot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        }
        SystemCallLatencyStatisticsTableAnalysisTest.switchTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void createTree() {
        SWTBotUtils.openView((String)VIEW_ID);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView viewBot = bot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof SystemCallLatencyStatisticsView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fTreeBot = viewBot.bot().tree();
        Assert.assertNotNull((Object)this.fTreeBot);
    }

    @After
    public void closeTree() {
        SWTWorkbenchBot swtWorkbenchBot = new SWTWorkbenchBot();
        SWTBotView viewBot = swtWorkbenchBot.viewById(VIEW_ID);
        viewBot.close();
    }

    private static void switchTracingPerspective() {
        final Exception[] retE = new Exception[1];
        if (!((Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                try {
                    PlatformUI.getWorkbench().showPerspective(SystemCallLatencyStatisticsTableAnalysisTest.TRACING_PERSPECTIVE_ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    retE[0] = e;
                    return false;
                }
                return true;
            }
        })).booleanValue()) {
            Assert.fail((String)retE[0].getMessage());
        }
    }

    @Test
    public void testWithTrace() throws IOException, NoSuchMethodException, SecurityException, IllegalArgumentException {
        String tracePath = FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).getPath();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView view = bot.viewById(VIEW_ID);
        view.close();
        bot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
        this.createTree();
        WaitUtils.waitForJobs();
        Assert.assertEquals((Object)"1.000 \u00b5s", (Object)this.fTreeBot.cell(0, 1));
        Assert.assertEquals((Object)"5.904 s", (Object)this.fTreeBot.cell(0, 2));
        Assert.assertEquals((Object)"15.628 ms", (Object)this.fTreeBot.cell(0, 3));
        Assert.assertEquals((Object)"175.875 ms", (Object)this.fTreeBot.cell(0, 4));
        Assert.assertEquals((Object)"1801", (Object)this.fTreeBot.cell(0, 5));
        SWTBotTreeItem treeItem = this.fTreeBot.getTreeItem("Total");
        Assert.assertEquals((long)55L, (long)treeItem.getNodes().size());
        SystemCallLatencyStatisticsTableAnalysisTest.validate(treeItem.getNode(2), "select", "13.600 \u00b5s", "1.509 s", "192.251 ms", "386.369 ms", "58");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(treeItem.getNode(3), "poll", "6.300 \u00b5s", "6.800 \u00b5s", "6.550 \u00b5s", "---", "2");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(treeItem.getNode(5), "set_tid_address", "2.300 \u00b5s", "2.300 \u00b5s", "2.300 \u00b5s", "---", "1");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(treeItem.getNode(7), "pipe", "27.900 \u00b5s", "29.700 \u00b5s", "28.800 \u00b5s", "---", "2");
        SystemCallLatencyStatisticsTableAnalysisTest.testToTsv(view);
        SWTBotMenu menuBot = view.viewMenu().menu(new String[]{"Export to TSV"});
        Assert.assertTrue((boolean)menuBot.isEnabled());
        Assert.assertTrue((boolean)menuBot.isVisible());
        bot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)bot);
    }

    private static void testToTsv(SWTBotView view) throws NoSuchMethodException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Assert.assertNotNull((Object)os);
        IViewPart viewPart = ((IViewReference)view.getReference()).getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof SystemCallLatencyStatisticsView));
        Class<@NonNull AbstractSegmentStoreStatisticsView> clazz = AbstractSegmentStoreStatisticsView.class;
        Method method = clazz.getDeclaredMethod("exportToTsv", OutputStream.class);
        method.setAccessible(true);
        Exception[] except = new Exception[1];
        UIThreadRunnable.syncExec(() -> {
            try {
                method.invoke((Object)((SystemCallLatencyStatisticsView)viewPart), os);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                exceptionArray[0] = e;
            }
        });
        Assert.assertNull((Object)except[0]);
        String[] lines = String.valueOf(os).split(System.getProperty("line.separator"));
        Assert.assertNotNull((Object)lines);
        Assert.assertEquals((String)"header", (Object)"Level\tMinimum\tMaximum\tAverage\tStandard Deviation\tCount\tTotal", (Object)lines[0]);
        Assert.assertEquals((String)"line 1", (Object)"Total\t1.000 \u00b5s\t5.904 s\t15.628 ms\t175.875 ms\t1801\t28.146 s", (Object)lines[1]);
    }

    private static void validate(SWTBotTreeItem treeItem, String nodeName, String min, String max, String avg, String stdev, String count) {
        Assert.assertEquals((Object)nodeName, (Object)treeItem.cell(0));
        Assert.assertEquals((Object)min, (Object)treeItem.cell(1));
        Assert.assertEquals((Object)max, (Object)treeItem.cell(2));
        Assert.assertEquals((Object)avg, (Object)treeItem.cell(3));
        Assert.assertEquals((Object)stdev, (Object)treeItem.cell(4));
        Assert.assertEquals((Object)count, (Object)treeItem.cell(5));
    }
}

