/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.flamegraph;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.junit.Assert;
import org.junit.Test;

public class AggregatedCalledFunctionStatisticsTest {
    private static final @NonNull String PROCESS_PATH = "Processes";
    private static final @NonNull String THREAD_PATH = "Thread";
    private static final @NonNull String CALLSTACK_PATH = "CallStack";
    private static final String QUARK_0 = "0";
    private static final String QUARK_1 = "1";
    private static final String QUARK_2 = "2";
    private static final String QUARK_3 = "3";
    private static final String @NonNull [] CSP = new String[]{"CallStack"};
    private static final String @NonNull [] PP = new String[]{"Processes"};
    private static final String @NonNull [] TP = new String[]{"Thread"};
    private static final double ERROR = 1.0E-6;

    private static ITmfStateSystemBuilder createFixture() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"Test", (long)0L);
        ITmfStateSystemBuilder fixture = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        return fixture;
    }

    @Test
    public void TreeStatisticsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction SecondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Object[] secondFunctionChildren = SecondFunction.getChildren().toArray();
        AggregatedCalledFunction ThirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        @NonNull AggregatedCalledFunctionStatistics mainStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test main's maximum duration", (long)100L, (long)mainStatistics1.getMax());
        Assert.assertEquals((String)"Test main's minimum duration", (long)100L, (long)mainStatistics1.getMin());
        Assert.assertEquals((String)"Test main's maximum self time", (long)20L, (long)mainStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test main's minimum self time", (long)20L, (long)mainStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)mainStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test main's average duration", (double)100.0, (double)mainStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's standard deviation", (double)20.0, (double)mainStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's standard deviation", (double)Double.NaN, (double)mainStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's standard deviation", (double)Double.NaN, (double)mainStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = SecondFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test first function's maximum duration", (long)50L, (long)functionStatistics1.getMax());
        Assert.assertEquals((String)"Test first function's minimum duration", (long)30L, (long)functionStatistics1.getMin());
        Assert.assertEquals((String)"Test first function's maximum self time", (long)30L, (long)functionStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test first function's mininmum self time", (long)20L, (long)functionStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test first function's number of calls", (long)2L, (long)functionStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test first function's average duration", (double)40.0, (double)functionStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's average self time", (double)25.0, (double)functionStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's self time standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = ThirdFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test second function's maximum duration", (long)30L, (long)functionStatistics2.getMax());
        Assert.assertEquals((String)"Test second function's minimum duration", (long)30L, (long)functionStatistics2.getMin());
        Assert.assertEquals((String)"Test second function's maximum self time", (long)30L, (long)functionStatistics2.getMaxSelfTime());
        Assert.assertEquals((String)"Test second function's minimum self time", (long)30L, (long)functionStatistics2.getMinSelfTime());
        Assert.assertEquals((String)"Test second function's number of calls", (long)1L, (long)functionStatistics2.getNbSegments());
        Assert.assertEquals((String)"Test second function's average duration", (double)30.0, (double)functionStatistics2.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's average self time", (double)30.0, (double)functionStatistics2.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's self time standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDevSelfTime(), (double)1.0E-6);
    }

    @Test
    public void MergeFirstLevelCalleesStatisticsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Object[] secondFunctionChildren = secondFunction.getChildren().toArray();
        AggregatedCalledFunction leaf1 = (AggregatedCalledFunction)secondFunctionChildren[0];
        AggregatedCalledFunction leaf2 = (AggregatedCalledFunction)secondFunctionChildren[1];
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test first function's maximum duration", (long)100L, (long)functionStatistics1.getMax());
        Assert.assertEquals((String)"Test first function's minimum duration", (long)100L, (long)functionStatistics1.getMin());
        Assert.assertEquals((String)"Test first function's maximum self time", (long)20L, (long)functionStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test first function's minimum self time", (long)20L, (long)functionStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test first function's number of segments", (long)1L, (long)functionStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test first function's average duration", (double)100.0, (double)functionStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's average self time", (double)20.0, (double)functionStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = secondFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test second function's maximum duration", (long)50L, (long)functionStatistics2.getMax());
        Assert.assertEquals((String)"Test second function's minimum duration", (long)30L, (long)functionStatistics2.getMin());
        Assert.assertEquals((String)"Test second function's maximum self time", (long)20L, (long)functionStatistics2.getMaxSelfTime());
        Assert.assertEquals((String)"Test second function's minimum self time", (long)10L, (long)functionStatistics2.getMinSelfTime());
        Assert.assertEquals((String)"Test second function's number of calls", (long)2L, (long)functionStatistics2.getNbSegments());
        Assert.assertEquals((String)"Test second function's average duration", (double)40.0, (double)functionStatistics2.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's average self time", (double)15.0, (double)functionStatistics2.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics leafStatistics1 = leaf1.getFunctionStatistics();
        Assert.assertEquals((String)"Test first leaf's maximum duration", (long)30L, (long)leafStatistics1.getMax());
        Assert.assertEquals((String)"Test first leaf's minimum duration", (long)30L, (long)leafStatistics1.getMin());
        Assert.assertEquals((String)"Test first leaf's maximum self time", (long)30L, (long)leafStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test first leaf's minimum self time", (long)30L, (long)leafStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test first leaf's number of calls", (long)1L, (long)leafStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test first leaf's minimum duration", (double)30.0, (double)leafStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's average self time", (double)30.0, (double)leafStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's standard deviation", (double)Double.NaN, (double)leafStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's self time standard deviation", (double)Double.NaN, (double)leafStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics leafStatistics2 = leaf2.getFunctionStatistics();
        Assert.assertEquals((String)"Test second leaf's maximum duration", (long)20L, (long)leafStatistics2.getMax());
        Assert.assertEquals((String)"Test second leaf's minimum duration", (long)20L, (long)leafStatistics2.getMin());
        Assert.assertEquals((String)"Test second leaf's maximum self time", (long)20L, (long)leafStatistics2.getMaxSelfTime());
        Assert.assertEquals((String)"Test second leaf's minimum self time", (long)20L, (long)leafStatistics2.getMinSelfTime());
        Assert.assertEquals((String)"Test second leaf's number of calls", (long)1L, (long)leafStatistics2.getNbSegments());
        Assert.assertEquals((String)"Test second leaf's average duration", (double)20.0, (double)leafStatistics2.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's average self time", (double)20.0, (double)leafStatistics2.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's standard deviation", (double)Double.NaN, (double)leafStatistics2.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's self time standard deviation", (double)Double.NaN, (double)leafStatistics2.getStdDevSelfTime(), (double)1.0E-6);
    }

    @Test
    public void multiFunctionRootsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(40L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(81L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test first function's maximum duration", (long)50L, (long)functionStatistics1.getMax());
        Assert.assertEquals((String)"Test first function's minimum duration", (long)20L, (long)functionStatistics1.getMin());
        Assert.assertEquals((String)"Test first function's maximum self time", (long)40L, (long)functionStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test first function's minimum self time", (long)10L, (long)functionStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test first function's number of segments", (long)2L, (long)functionStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test first function's average duration", (double)35.0, (double)functionStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's average self time", (double)25.0, (double)functionStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's self time standard deviation", (double)Double.NaN, (double)functionStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = function2.getFunctionStatistics();
        Assert.assertEquals((String)"Test second function's maximum duration", (long)10L, (long)functionStatistics2.getMax());
        Assert.assertEquals((String)"Test second function's minimum duration", (long)10L, (long)functionStatistics2.getMin());
        Assert.assertEquals((String)"Test second function's maximum self time", (long)10L, (long)functionStatistics2.getMaxSelfTime());
        Assert.assertEquals((String)"Test second function's minimum self time", (long)10L, (long)functionStatistics2.getMinSelfTime());
        Assert.assertEquals((String)"Test second function's number of calls", (long)1L, (long)functionStatistics2.getNbSegments());
        Assert.assertEquals((String)"Test second function's average duration", (double)10.0, (double)functionStatistics2.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's average self time", (double)10.0, (double)functionStatistics2.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's self time standard deviation", (double)Double.NaN, (double)functionStatistics2.getStdDevSelfTime(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics3 = function3.getFunctionStatistics();
        Assert.assertEquals((String)"Test third function's maximum duration", (long)10L, (long)functionStatistics3.getMax());
        Assert.assertEquals((String)"Test third function's minimum duration", (long)10L, (long)functionStatistics3.getMin());
        Assert.assertEquals((String)"Test third function's maximum selftime", (long)10L, (long)functionStatistics3.getMaxSelfTime());
        Assert.assertEquals((String)"Test third function's minimum self time", (long)10L, (long)functionStatistics3.getMinSelfTime());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)functionStatistics3.getNbSegments());
        Assert.assertEquals((String)"Test third function's average duration", (double)10.0, (double)functionStatistics3.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's average self time", (double)10.0, (double)functionStatistics3.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's standard deviation", (double)Double.NaN, (double)functionStatistics3.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time standard deviation", (double)Double.NaN, (double)functionStatistics3.getStdDevSelfTime(), (double)1.0E-6);
    }

    private static void buildCallStack(ITmfStateSystemBuilder fixture) {
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(150L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(130L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(150L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(20L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_3});
        statev = TmfStateValue.newValueLong((long)4L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(151L);
    }

    @Test
    public void MergeSecondLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        AggregatedCalledFunctionStatisticsTest.buildCallStack(fixture);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertNotNull((Object)threads);
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction main = (AggregatedCalledFunction)children[0];
        Object[] mainChildren = main.getChildren().toArray();
        AggregatedCalledFunction function1 = (AggregatedCalledFunction)mainChildren[0];
        Object[] firstFunctionChildren = function1.getChildren().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        Object[] firstChildCallee = function2.getChildren().toArray();
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)firstChildCallee[0];
        AggregatedCalledFunctionStatistics mainStatistics1 = main.getFunctionStatistics();
        Assert.assertEquals((String)"Test main's maximum duration", (long)150L, (long)mainStatistics1.getMax());
        Assert.assertEquals((String)"Test main's minimum duration", (long)150L, (long)mainStatistics1.getMin());
        Assert.assertEquals((String)"Test main's maximum self time", (long)40L, (long)mainStatistics1.getMaxSelfTime());
        Assert.assertEquals((String)"Test main's minimum self time", (long)40L, (long)mainStatistics1.getMinSelfTime());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)mainStatistics1.getNbSegments());
        Assert.assertEquals((String)"Test main's average duration", (double)150.0, (double)mainStatistics1.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's average self time", (double)40.0, (double)mainStatistics1.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's standard deviation", (double)Double.NaN, (double)mainStatistics1.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's self time standard deviation", (double)Double.NaN, (double)mainStatistics1.getStdDevSelfTime(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics firstFunctionStatistics = function1.getFunctionStatistics();
        Assert.assertEquals((String)"Test first function's maximum duration", (long)50L, (long)firstFunctionStatistics.getMax());
        Assert.assertEquals((String)"Test first function's minimum duration", (long)20L, (long)firstFunctionStatistics.getMin());
        Assert.assertEquals((String)"Test first function's maximum self time", (long)30L, (long)firstFunctionStatistics.getMaxSelfTime());
        Assert.assertEquals((String)"Test first function's minimum self time", (long)10L, (long)firstFunctionStatistics.getMinSelfTime());
        Assert.assertEquals((String)"Test first function's number of segments", (long)3L, (long)firstFunctionStatistics.getNbSegments());
        Assert.assertEquals((String)"Test first function's average duration", (double)36.666666667, (double)firstFunctionStatistics.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's average self time", (double)20.0, (double)firstFunctionStatistics.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's standard deviation", (double)15.275252316, (double)firstFunctionStatistics.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first function's self time standard deviation", (double)10.0, (double)firstFunctionStatistics.getStdDevSelfTime(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics secondFunctionStatistics2 = function2.getFunctionStatistics();
        Assert.assertEquals((String)"Test second function's maximum duration", (long)30L, (long)secondFunctionStatistics2.getMax());
        Assert.assertEquals((String)"Test second function's minimum duration", (long)10L, (long)secondFunctionStatistics2.getMin());
        Assert.assertEquals((String)"Test second function's maximum self time", (long)10L, (long)secondFunctionStatistics2.getMaxSelfTime());
        Assert.assertEquals((String)"Test second function's minimum self time", (long)0L, (long)secondFunctionStatistics2.getMinSelfTime());
        Assert.assertEquals((String)"Test second function's number of segments", (long)2L, (long)secondFunctionStatistics2.getNbSegments());
        Assert.assertEquals((String)"Test second function's average duration", (double)20.0, (double)secondFunctionStatistics2.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's average self time", (double)5.0, (double)secondFunctionStatistics2.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's standard deviation", (double)Double.NaN, (double)secondFunctionStatistics2.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second function's self time standard deviation", (double)Double.NaN, (double)secondFunctionStatistics2.getStdDevSelfTime(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics thirdFunctionStatistics3 = function3.getFunctionStatistics();
        Assert.assertEquals((String)"Test third function's maximum duration", (long)10L, (long)thirdFunctionStatistics3.getMax());
        Assert.assertEquals((String)"Test third function's minimum duration", (long)10L, (long)thirdFunctionStatistics3.getMin());
        Assert.assertEquals((String)"Test third function's maximum self time", (long)10L, (long)thirdFunctionStatistics3.getMaxSelfTime());
        Assert.assertEquals((String)"Test third function's minimum self time", (long)10L, (long)thirdFunctionStatistics3.getMinSelfTime());
        Assert.assertEquals((String)"Test third function's number of segments", (long)1L, (long)thirdFunctionStatistics3.getNbSegments());
        Assert.assertEquals((String)"Test third function's average duration", (double)10.0, (double)thirdFunctionStatistics3.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's average self time", (double)10.0, (double)thirdFunctionStatistics3.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time deviation", (double)Double.NaN, (double)thirdFunctionStatistics3.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time standard deviation", (double)Double.NaN, (double)thirdFunctionStatistics3.getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics fourthFunctionStatistics4 = function4.getFunctionStatistics();
        Assert.assertEquals((String)"Test fourth function's maximum duration", (long)20L, (long)fourthFunctionStatistics4.getMax());
        Assert.assertEquals((String)"Test fourth function's minimum duration", (long)10L, (long)fourthFunctionStatistics4.getMin());
        Assert.assertEquals((String)"Test fourth function's maximum self time", (long)20L, (long)fourthFunctionStatistics4.getMaxSelfTime());
        Assert.assertEquals((String)"Test fourth function's maximum self time", (long)10L, (long)fourthFunctionStatistics4.getMinSelfTime());
        Assert.assertEquals((String)"Test fourth function's number of segments", (long)2L, (long)fourthFunctionStatistics4.getNbSegments());
        Assert.assertEquals((String)"Test fourth function's average duration", (double)15.0, (double)fourthFunctionStatistics4.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's average duration", (double)15.0, (double)fourthFunctionStatistics4.getAverageSelfTime(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's standard deviation", (double)Double.NaN, (double)fourthFunctionStatistics4.getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's self time deviation", (double)Double.NaN, (double)fourthFunctionStatistics4.getStdDevSelfTime(), (double)1.0E-6);
    }

    private class CGAnalysis
    extends CallGraphAnalysis {
        private CGAnalysis() {
        }

        protected boolean iterateOverStateSystem(@Nullable ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, String[] callStackPath, IProgressMonitor monitor) {
            return super.iterateOverStateSystem(ss, threadsPattern, processesPattern, callStackPath, monitor);
        }

        public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
            return Collections.EMPTY_LIST;
        }
    }
}

