/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics.StubSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.Assert;
import org.junit.Test;

public class AbstractStatsAnalysisTest {
    @Test
    public void testExecuteNoTrace() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        Assert.assertFalse((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testExecuteNoDepend() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        fixture.setTrace((ITmfTrace)new TmfXmlTraceStub());
        Assert.assertFalse((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testExecute() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        fixture.setTrace((ITmfTrace)trace);
        fixture.getDependentAnalyses();
        Assert.assertTrue((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testTotalStats() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats();
        SegmentStoreStatistics totalStats = fixture.getTotalStats();
        Assert.assertNotNull((Object)totalStats);
        Assert.assertEquals((long)65535L, (long)totalStats.getNbSegments());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPerTypeStats() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats();
        @NonNull @NonNull Map perTypeStats = fixture.getPerSegmentTypeStats();
        Assert.assertNotNull((Object)perTypeStats);
        Assert.assertEquals((long)2L, (long)perTypeStats.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"odd", (Object)"even"), perTypeStats.keySet());
        SegmentStoreStatistics segmentStoreStatistics = (SegmentStoreStatistics)perTypeStats.get("even");
        Assert.assertNotNull((Object)segmentStoreStatistics);
        Assert.assertEquals((long)32768L, (long)segmentStoreStatistics.getNbSegments());
    }

    @Test
    public void testPartialStats() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats();
        SegmentStoreStatistics totalStats = fixture.getTotalStatsForRange(100L, 1100L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)totalStats);
        Assert.assertEquals((long)1051L, (long)totalStats.getNbSegments());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPartialPerTypeStats() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats();
        @NonNull @NonNull Map perTypeStats = fixture.getPerSegmentTypeStatsForRange(100L, 1100L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)perTypeStats);
        Assert.assertEquals((long)2L, (long)perTypeStats.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"odd", (Object)"even"), perTypeStats.keySet());
        SegmentStoreStatistics segmentStoreStatistics = (SegmentStoreStatistics)perTypeStats.get("even");
        Assert.assertNotNull((Object)segmentStoreStatistics);
        Assert.assertEquals((long)526L, (long)segmentStoreStatistics.getNbSegments());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPartialPerTypeStatsCancel() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats();
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        @NonNull @NonNull Map perTypeStats = fixture.getPerSegmentTypeStatsForRange(100L, 1100L, (IProgressMonitor)monitor);
        Assert.assertEquals(Collections.emptyMap(), (Object)perTypeStats);
    }

    private static StubSegmentStatisticsAnalysis getValidSegmentStats() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        fixture.setTrace((ITmfTrace)trace);
        fixture.getDependentAnalyses();
        fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor());
        return fixture;
    }
}

