/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class OfflineStatisticsCalculator {
    private final Collection<@NonNull ISegment> fSs;

    public OfflineStatisticsCalculator(Collection<@NonNull ISegment> ss) {
        this.fSs = ss;
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (ISegment interval : this.fSs) {
            max = Math.max(max, interval.getLength());
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (ISegment interval : this.fSs) {
            min = Math.min(min, interval.getLength());
        }
        return min;
    }

    public double getAvg() {
        double total = 0.0;
        for (ISegment interval : this.fSs) {
            total += (double)interval.getLength() / (double)this.fSs.size();
        }
        return total;
    }

    public double getStdDev() {
        if (this.fSs.size() < 3) {
            return Double.NaN;
        }
        double mean = this.getAvg();
        double totalVariance = 0.0;
        for (ISegment interval : this.fSs) {
            double result = (double)interval.getLength() - mean;
            totalVariance += result * result / (double)(this.fSs.size() - 1);
        }
        return Math.sqrt(totalVariance);
    }

    public long getTotal() {
        long total = 0L;
        for (ISegment interval : this.fSs) {
            total += interval.getLength();
        }
        return total;
    }

    public int count() {
        return this.fSs.size();
    }
}

