/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics.OfflineStatisticsCalculator;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentStoreStatisticsTest {
    private static final int MEDIUM_AMOUNT_OF_SEGMENTS = 100;
    private static final int LARGE_AMOUNT_OF_SEGMENTS = 1000000;
    private static final double NO_ERROR = 0.0;
    private static final double ERROR = 1.0E-6;
    private static final double APPROX_ERROR = 1.0E-4;

    private static void testOnlineVsOffline(List<@NonNull ISegment> fixture) {
        SegmentStoreStatisticsTest.validate(new OfflineStatisticsCalculator(fixture), SegmentStoreStatisticsTest.getSegStoreStat(fixture));
    }

    @Test
    public void climbTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>(100);
        int i = 0;
        while (i < 100) {
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(i, i * 2));
            ++i;
        }
        SegmentStoreStatistics sss = SegmentStoreStatisticsTest.getSegStoreStat(fixture);
        Assert.assertEquals((String)"Average", (double)49.5, (double)sss.getAverage(), (double)1.0E-6);
        Assert.assertEquals((String)"Min", (long)0L, (long)sss.getMin());
        Assert.assertEquals((String)"Max", (long)99L, (long)sss.getMax());
        Assert.assertEquals((String)"Standard Deviation", (double)29.0, (double)sss.getStdDev(), (double)0.02);
        Assert.assertEquals((String)"Min Segment", (long)0L, (long)sss.getMinSegment().getLength());
        Assert.assertEquals((String)"Max Segment", (long)99L, (long)sss.getMaxSegment().getLength());
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    private static SegmentStoreStatistics getSegStoreStat(List<@NonNull ISegment> fixture) {
        SegmentStoreStatistics sss = new SegmentStoreStatistics();
        for (ISegment seg : fixture) {
            sss.update(seg);
        }
        return sss;
    }

    @Test
    public void decrementingTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>(100);
        int i = 100;
        while (i >= 0) {
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(i, i * 2));
            --i;
        }
        SegmentStoreStatistics sss = SegmentStoreStatisticsTest.getSegStoreStat(fixture);
        Assert.assertEquals((String)"Average", (double)50.0, (double)sss.getAverage(), (double)0.0);
        Assert.assertEquals((String)"Min", (long)0L, (long)sss.getMin());
        Assert.assertEquals((String)"Max", (long)100L, (long)sss.getMax());
        Assert.assertEquals((String)"Standard Deviation", (double)29.3, (double)sss.getStdDev(), (double)0.01);
        Assert.assertEquals((String)"Min Segment", (long)0L, (long)sss.getMinSegment().getLength());
        Assert.assertEquals((String)"Max Segment", (long)100L, (long)sss.getMaxSegment().getLength());
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    @Test
    public void smallTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 1;
        while (i >= 0) {
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(i, i * 2));
            --i;
        }
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    @Test
    public void largeTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>(1000000);
        int i = 1;
        while (i <= 1000000) {
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(i, i * 2));
            ++i;
        }
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    @Test
    public void noiseTest() {
        Random rnd = new Random();
        rnd.setSeed(1234L);
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>(1000000);
        int i = 1;
        while (i <= 1000000) {
            int start = Math.abs(rnd.nextInt(100000000));
            int end = start + Math.abs(rnd.nextInt(1000000));
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(start, end));
            ++i;
        }
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    @Test
    public void gaussianNoiseTest() {
        Random rnd = new Random();
        rnd.setSeed(1234L);
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>(1000000);
        int i = 1;
        while (i <= 1000000) {
            int start = Math.abs(rnd.nextInt(100000000));
            int delta = Math.abs(rnd.nextInt(1000));
            int end = start + delta * delta;
            fixture.add((ISegment)SegmentStoreStatisticsTest.createDummySegment(start, end));
            ++i;
        }
        SegmentStoreStatisticsTest.testOnlineVsOffline(fixture);
    }

    @Test
    public void streamBuildingTest() {
        SegmentStoreStatistics expected = new SegmentStoreStatistics();
        ArrayList<@NonNull BasicSegment> fixture = new ArrayList<BasicSegment>(1000000);
        long i = 0L;
        while (i < 1000000L) {
            fixture.add(new BasicSegment(i, i + 2L));
            ++i;
        }
        fixture.forEach(e -> expected.update(e));
        SegmentStoreStatistics actual = fixture.stream().collect(SegmentStoreStatistics::new, SegmentStoreStatistics::update, SegmentStoreStatistics::merge);
        SegmentStoreStatisticsTest.validate(expected, actual);
    }

    @Test
    public void parallelStreamBuildingTest() {
        SegmentStoreStatistics expected = new SegmentStoreStatistics();
        ArrayList<@NonNull BasicSegment> fixture = new ArrayList<BasicSegment>(1000000);
        long i = 0L;
        while (i < 1000000L) {
            fixture.add(new BasicSegment(i, i + 2L));
            ++i;
        }
        fixture.forEach(e -> expected.update(e));
        SegmentStoreStatistics actual = fixture.parallelStream().collect(SegmentStoreStatistics::new, SegmentStoreStatistics::update, SegmentStoreStatistics::merge);
        SegmentStoreStatisticsTest.validate(expected, actual);
    }

    @Test
    public void mergeStatisticsNodesTest() {
        BasicSegment seg;
        SegmentStoreStatistics expected = new SegmentStoreStatistics();
        SegmentStoreStatistics a = new SegmentStoreStatistics();
        SegmentStoreStatistics b = new SegmentStoreStatistics();
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 0;
        while (i < 10) {
            seg = new BasicSegment((long)i, (long)(i * 2 + 2));
            expected.update((ISegment)seg);
            a.update((ISegment)seg);
            fixture.add((ISegment)seg);
            ++i;
        }
        i = 0;
        while (i < 10) {
            seg = new BasicSegment((long)i, (long)(i * 2 + 2));
            expected.update((ISegment)seg);
            b.update((ISegment)seg);
            fixture.add((ISegment)seg);
            ++i;
        }
        a.merge(b);
        OfflineStatisticsCalculator offlineExpected = new OfflineStatisticsCalculator(fixture);
        SegmentStoreStatisticsTest.validate(offlineExpected, expected);
        SegmentStoreStatisticsTest.validate(expected, a);
    }

    @Test
    public void mergeStatisticsRandomNodesTest() {
        BasicSegment seg;
        int end;
        int delta;
        int start;
        SegmentStoreStatistics expected = new SegmentStoreStatistics();
        SegmentStoreStatistics a = new SegmentStoreStatistics();
        SegmentStoreStatistics b = new SegmentStoreStatistics();
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        Random rnd = new Random();
        rnd.setSeed(10L);
        int size = rnd.nextInt(1000);
        int size2 = rnd.nextInt(1000);
        int i = 0;
        while (i < size) {
            start = Math.abs(rnd.nextInt(100000000));
            delta = Math.abs(rnd.nextInt(1000));
            end = start + delta * delta;
            seg = new BasicSegment((long)start, (long)end);
            expected.update((ISegment)seg);
            a.update((ISegment)seg);
            fixture.add((ISegment)seg);
            ++i;
        }
        i = 0;
        while (i < size2) {
            start = Math.abs(rnd.nextInt(100000000));
            delta = Math.abs(rnd.nextInt(1000));
            end = start + delta * delta;
            seg = new BasicSegment((long)start, (long)end);
            expected.update((ISegment)seg);
            b.update((ISegment)seg);
            fixture.add((ISegment)seg);
            ++i;
        }
        a.merge(b);
        Assert.assertEquals((long)(size + size2), (long)a.getNbSegments());
        OfflineStatisticsCalculator offlineExpected = new OfflineStatisticsCalculator(fixture);
        SegmentStoreStatisticsTest.validate(offlineExpected, expected);
        SegmentStoreStatisticsTest.validate(expected, a);
    }

    @Test
    public void mergeStatisticsOverlappingNodesTest() {
        SegmentStoreStatistics expected = new SegmentStoreStatistics();
        SegmentStoreStatistics a = new SegmentStoreStatistics();
        SegmentStoreStatistics b = new SegmentStoreStatistics();
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 0;
        while (i < 100) {
            BasicSegment seg = new BasicSegment((long)i, (long)(i * 2 + 2));
            expected.update((ISegment)seg);
            if ((i & 2) != 0) {
                a.update((ISegment)seg);
            } else {
                b.update((ISegment)seg);
            }
            fixture.add((ISegment)seg);
            ++i;
        }
        a.merge(b);
        OfflineStatisticsCalculator offlineExpected = new OfflineStatisticsCalculator(fixture);
        SegmentStoreStatisticsTest.validate(offlineExpected, expected);
        SegmentStoreStatisticsTest.validate(expected, a);
    }

    private static @NonNull SegmentStoreStatistics fillSmallStatistics() {
        SegmentStoreStatistics stats = new SegmentStoreStatistics();
        int i = 0;
        while (i < 10) {
            BasicSegment seg = new BasicSegment((long)i, (long)(i * 2 + 2));
            stats.update((ISegment)seg);
            ++i;
        }
        return stats;
    }

    @Test
    public void mergeStatisticsCornerCaseNodesTest() {
        BasicSegment segment = new BasicSegment(1L, 5L);
        SegmentStoreStatistics noSegments = new SegmentStoreStatistics();
        SegmentStoreStatistics oneSegment = new SegmentStoreStatistics();
        oneSegment.update((ISegment)segment);
        SegmentStoreStatistics testStats = new SegmentStoreStatistics();
        SegmentStoreStatistics testStats2 = new SegmentStoreStatistics();
        testStats.update((ISegment)segment);
        testStats.merge(testStats2);
        SegmentStoreStatisticsTest.validate(oneSegment, testStats);
        SegmentStoreStatisticsTest.validate(noSegments, testStats2);
        testStats2.merge(testStats);
        SegmentStoreStatisticsTest.validate(oneSegment, testStats);
        SegmentStoreStatisticsTest.validate(oneSegment, testStats2);
        SegmentStoreStatistics expected = SegmentStoreStatisticsTest.fillSmallStatistics();
        expected.update((ISegment)segment);
        testStats = SegmentStoreStatisticsTest.fillSmallStatistics();
        testStats.merge(testStats2);
        SegmentStoreStatisticsTest.validate(oneSegment, testStats2);
        SegmentStoreStatisticsTest.validate(expected, testStats);
        testStats = SegmentStoreStatisticsTest.fillSmallStatistics();
        testStats2.merge(testStats);
        SegmentStoreStatisticsTest.validate(SegmentStoreStatisticsTest.fillSmallStatistics(), testStats);
        SegmentStoreStatisticsTest.validate(expected, testStats2);
    }

    private static void validate(SegmentStoreStatistics expected, SegmentStoreStatistics toBeTested) {
        Assert.assertEquals((String)"# of Segments", (long)expected.getNbSegments(), (long)toBeTested.getNbSegments());
        Assert.assertEquals((String)"Total duration", (double)expected.getTotal(), (double)toBeTested.getTotal(), (double)(1.0E-6 * expected.getTotal()));
        Assert.assertEquals((String)"Average", (double)expected.getAverage(), (double)toBeTested.getAverage(), (double)(1.0E-6 * expected.getAverage()));
        Assert.assertEquals((String)"Min", (long)expected.getMin(), (long)toBeTested.getMin());
        Assert.assertEquals((String)"Max", (long)expected.getMax(), (long)toBeTested.getMax());
        Assert.assertEquals((String)"Min Segment", (long)expected.getMinSegment().getLength(), (long)toBeTested.getMinSegment().getLength());
        Assert.assertEquals((String)"Max Segment", (long)expected.getMaxSegment().getLength(), (long)toBeTested.getMaxSegment().getLength());
        Assert.assertEquals((String)"Standard Deviation", (double)expected.getStdDev(), (double)toBeTested.getStdDev(), (double)(1.0E-4 * expected.getStdDev()));
    }

    private static void validate(OfflineStatisticsCalculator osc, SegmentStoreStatistics sss) {
        Assert.assertEquals((String)"# of Segments", (long)osc.count(), (long)sss.getNbSegments());
        Assert.assertEquals((String)"Total duration", (double)osc.getTotal(), (double)sss.getTotal(), (double)(1.0E-6 * (double)osc.getTotal()));
        Assert.assertEquals((String)"Average", (double)osc.getAvg(), (double)sss.getAverage(), (double)(1.0E-6 * osc.getAvg()));
        Assert.assertEquals((String)"Min", (long)osc.getMin(), (long)sss.getMin());
        Assert.assertEquals((String)"Max", (long)osc.getMax(), (long)sss.getMax());
        Assert.assertEquals((String)"Min Segment", (long)osc.getMin(), (long)sss.getMinSegment().getLength());
        Assert.assertEquals((String)"Max Segment", (long)osc.getMax(), (long)sss.getMaxSegment().getLength());
        Assert.assertEquals((String)"Standard Deviation", (double)osc.getStdDev(), (double)sss.getStdDev(), (double)(1.0E-6 * osc.getStdDev()));
    }

    private static @NonNull BasicSegment createDummySegment(int start, int end) {
        return new BasicSegment((long)start, (long)end);
    }
}

