/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunctionStatistics;

public class AggregatedCalledFunction {
    private final Object fSymbol;
    private final int fDepth;
    private final int fMaxDepth;
    private final Map<Object, AggregatedCalledFunction> fChildren = new HashMap<Object, AggregatedCalledFunction>();
    private final @Nullable AggregatedCalledFunction fParent;
    private final AggregatedCalledFunctionStatistics fStatistics;
    private long fDuration;
    private long fSelfTime;
    private final int fProcessId;

    public AggregatedCalledFunction(AbstractCalledFunction calledFunction, AggregatedCalledFunction parent) {
        this.fSymbol = calledFunction.getSymbol();
        this.fDuration = calledFunction.getLength();
        this.fSelfTime = calledFunction.getLength();
        this.fDepth = calledFunction.getDepth();
        this.fProcessId = calledFunction.getProcessId();
        this.fMaxDepth = parent.getMaxDepth();
        this.fParent = parent;
        this.fStatistics = new AggregatedCalledFunctionStatistics(calledFunction, calledFunction);
    }

    public AggregatedCalledFunction(AbstractCalledFunction calledFunction, int maxDepth) {
        this.fSymbol = calledFunction.getSymbol();
        this.fDuration = calledFunction.getLength();
        this.fSelfTime = calledFunction.getLength();
        this.fDepth = calledFunction.getDepth();
        this.fProcessId = calledFunction.getProcessId();
        this.fMaxDepth = maxDepth;
        this.fParent = null;
        this.fStatistics = new AggregatedCalledFunctionStatistics(calledFunction, calledFunction);
    }

    public Object getSymbol() {
        return this.fSymbol;
    }

    public synchronized Collection<AggregatedCalledFunction> getChildren() {
        return this.fChildren.values();
    }

    public @Nullable AggregatedCalledFunction getParent() {
        return this.fParent;
    }

    public synchronized void addChild(AggregatedCalledFunction child) {
        AggregatedCalledFunction node = this.fChildren.get(child.getSymbol());
        if (node == null) {
            this.fChildren.put(child.getSymbol(), child);
        } else {
            AggregatedCalledFunction.merge(node, child);
            this.fChildren.replace(node.getSymbol(), node);
        }
        this.fSelfTime -= child.fDuration;
        this.fStatistics.initializeMaxMinSelfTime(this.fSelfTime);
    }

    private void addToDuration(long duration) {
        this.fDuration += duration;
    }

    private static void mergeChildren(AggregatedCalledFunction firstNode, AggregatedCalledFunction secondNode) {
        for (Map.Entry<Object, AggregatedCalledFunction> FunctionEntry : secondNode.fChildren.entrySet()) {
            Object childSymbol = NonNullUtils.checkNotNull((Object)FunctionEntry.getKey());
            AggregatedCalledFunction secondNodeChild = (AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)FunctionEntry.getValue());
            AggregatedCalledFunction aggregatedCalledFunction = firstNode.fChildren.get(childSymbol);
            if (aggregatedCalledFunction == null) {
                firstNode.fChildren.put(secondNodeChild.getSymbol(), secondNodeChild);
                continue;
            }
            AggregatedCalledFunction firstNodeChild = aggregatedCalledFunction;
            AggregatedCalledFunction.merge(firstNodeChild, secondNodeChild);
            firstNode.fChildren.replace(firstNodeChild.getSymbol(), firstNodeChild);
        }
    }

    private static void merge(AggregatedCalledFunction destination, AggregatedCalledFunction source) {
        long sourceDuration = source.getDuration();
        long sourceSelfTime = source.getSelfTime();
        destination.addToDuration(sourceDuration);
        destination.addToSelfTime(sourceSelfTime);
        destination.getFunctionStatistics().update(source.getFunctionStatistics(), sourceDuration, sourceSelfTime);
        AggregatedCalledFunction.mergeChildren(destination, source);
    }

    public long getDuration() {
        return this.fDuration;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public int getMaxDepth() {
        return this.fMaxDepth;
    }

    public long getNbCalls() {
        return this.fStatistics.getNbSegments();
    }

    public long getSelfTime() {
        return this.fSelfTime;
    }

    public void addToSelfTime(long selfTime) {
        this.fSelfTime += selfTime;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public Boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public AggregatedCalledFunctionStatistics getFunctionStatistics() {
        return this.fStatistics;
    }
}

