/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.callgraph;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCanvas;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.flamegraph.AggregationTreeTest;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.ISegmentStoreDensityViewerDataListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph.CallGraphDensityView;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.swtchart.ISeries;

public class CallGraphDensityViewTest
extends AggregationTreeTest {
    private static final String CALLGRAPHDENSITY_ID = CallGraphDensityView.ID;
    private final @NonNull ISegmentStoreDensityViewerDataListener fSyncListener = new ISegmentStoreDensityViewerDataListener(){

        public void dataChanged(List<ISegment> newData) {
            CallGraphDensityViewTest.this.fLatch.countDown();
        }

        public void dataSelectionChanged(@Nullable List<@NonNull ISegment> newSelectionData) {
        }
    };
    private SWTWorkbenchBot fBot;
    private SWTBotView fView;
    private CallGraphDensityView fFuncDensityView;
    private SWTBotTable fTableBot;
    private SWTBotCanvas fDensityBot;
    private AbstractSegmentStoreDensityViewer fDensityViewer;
    private AbstractSegmentStoreTableViewer fTableViewer;
    private CountDownLatch fLatch;
    private static final Logger fLogger = Logger.getRootLogger();

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void before() {
        this.fBot = new SWTWorkbenchBot();
        SWTBotUtils.openView((String)CALLGRAPHDENSITY_ID);
        SWTBotView view = this.fBot.viewById(CALLGRAPHDENSITY_ID);
        Assert.assertNotNull((Object)view);
        this.fView = view;
        CallGraphDensityView funcDensityView = (CallGraphDensityView)UIThreadRunnable.syncExec(() -> {
            IViewPart viewRef = this.fView.getViewReference().getView(true);
            return viewRef instanceof CallGraphDensityView ? (CallGraphDensityView)viewRef : null;
        });
        Assert.assertNotNull((Object)funcDensityView);
        this.fTableBot = this.fView.bot().table();
        Assert.assertNotNull((Object)this.fTableBot);
        this.fDensityBot = this.fView.bot().canvas();
        Assert.assertNotNull((Object)this.fDensityBot);
        this.fDensityViewer = funcDensityView.getDensityViewer();
        Assert.assertNotNull((Object)this.fDensityViewer);
        this.fLatch = new CountDownLatch(1);
        this.fDensityViewer.removeDataListener(this.fSyncListener);
        this.fDensityViewer.addDataListener(this.fSyncListener);
        this.fTableViewer = funcDensityView.getTableViewer();
        Assert.assertNotNull((Object)this.fTableViewer);
        SWTBotUtils.maximize((IViewPart)funcDensityView);
        this.fFuncDensityView = funcDensityView;
    }

    @After
    public void after() {
        CallGraphDensityView funcDensityView = this.fFuncDensityView;
        Assert.assertNotNull((Object)funcDensityView);
        SWTBotUtils.maximize((IViewPart)funcDensityView);
    }

    public void emptyStateSystemTest() {
        super.emptyStateSystemTest();
        this.loadData();
        Assert.assertEquals((long)0L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        Assert.assertNotNull((Object)series);
    }

    public void cascadeTest() {
        super.cascadeTest();
        this.loadData();
        Assert.assertEquals((long)3L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)3.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)sss.getAverage(), (double)0.02);
    }

    public void mergeFirstLevelCalleesTest() {
        super.mergeFirstLevelCalleesTest();
        this.loadData();
        Assert.assertEquals((long)5L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)5.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)sss.getAverage(), (double)0.03);
    }

    public void multiFunctionRootsSecondTest() {
        super.multiFunctionRootsSecondTest();
        this.loadData();
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)4.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)sss.getAverage(), (double)0.02);
    }

    public void mergeSecondLevelCalleesTest() {
        super.mergeSecondLevelCalleesTest();
        this.loadData();
        Assert.assertEquals((long)8L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        double[] ySeries = series.getYSeries();
        Assert.assertNotNull((Object)ySeries);
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)8.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.06, (double)sss.getAverage(), (double)0.02);
    }

    public void multiFunctionRootsTest() {
        super.multiFunctionRootsTest();
        this.loadData();
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        double[] ySeries = series.getYSeries();
        Assert.assertNotNull((Object)ySeries);
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)4.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)sss.getAverage(), (double)0.02);
    }

    public void treeTest() {
        super.treeTest();
        this.loadData();
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        double[] ySeries = series.getYSeries();
        Assert.assertNotNull((Object)ySeries);
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)4.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)sss.getAverage(), (double)0.02);
    }

    public void largeTest() {
        super.largeTest();
        this.loadData();
        Assert.assertEquals((long)1000L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        double[] ySeries = series.getYSeries();
        Assert.assertNotNull((Object)ySeries);
        SegmentStoreStatistics sss = CallGraphDensityViewTest.getDescriptiveStatistics(series);
        Assert.assertEquals((double)1000.0, (double)sss.getTotal(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)sss.getAverage(), (double)1.0);
    }

    private ISeries getSeries() {
        AbstractSegmentStoreDensityViewer densityViewer = this.fDensityViewer;
        Assert.assertNotNull((Object)densityViewer);
        ISeries[] serieses = densityViewer.getControl().getSeriesSet().getSeries();
        Assert.assertNotNull((Object)serieses);
        Assert.assertTrue((serieses.length > 0 ? 1 : 0) != 0);
        ISeries series = serieses[0];
        Assert.assertNotNull((Object)series);
        return series;
    }

    private void loadData() {
        AggregationTreeTest.CGAnalysis cga = this.getCga();
        UIThreadRunnable.syncExec(() -> this.lambda$1((ISegmentStoreProvider)cga));
        if (cga != null) {
            try {
                Assert.assertTrue((boolean)this.fLatch.await(20L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private static SegmentStoreStatistics getDescriptiveStatistics(ISeries series) {
        double[] ySeries = series.getYSeries();
        Assert.assertNotNull((Object)ySeries);
        SegmentStoreStatistics sss = new SegmentStoreStatistics();
        double[] dArray = ySeries;
        int n = ySeries.length;
        int n2 = 0;
        while (n2 < n) {
            double item = dArray[n2];
            sss.update((ISegment)new BasicSegment(0L, (long)(item - 1.0)));
            ++n2;
        }
        return sss;
    }

    private /* synthetic */ void lambda$1(ISegmentStoreProvider iSegmentStoreProvider) {
        this.fTableViewer.setData(iSegmentStoreProvider);
        this.fDensityViewer.setSegmentProvider(iSegmentStoreProvider);
        this.fDensityViewer.updateWithRange(TmfTimeRange.ETERNITY);
        this.fDensityViewer.refresh();
    }
}

