/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.table;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentTableTest {
    private AbstractSegmentStoreTableView fTableView;
    private AbstractSegmentStoreTableViewer fTable;
    private ISegmentStoreProvider fSsp;
    private final ISegmentStore<@NonNull ISegment> fSs = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast});
    private static final Logger fLogger = Logger.getRootLogger();

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        List openViews = bot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
            bot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        }
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void init() {
        this.setTableView(this.openTable());
        Assert.assertNotNull((Object)this.getTableView());
        this.setTable(this.getTableView().getSegmentStoreViewer());
        Assert.assertNotNull((Object)this.getTable());
        ISegmentStoreProvider segStoreProvider = this.getSegStoreProvider();
        Assert.assertNotNull((Object)segStoreProvider);
        UIThreadRunnable.syncExec(() -> this.getTable().setSegmentProvider(segStoreProvider));
    }

    @After
    public void finish() {
        new SWTWorkbenchBot().viewById(this.getTableView().getSite().getId()).close();
    }

    protected AbstractSegmentStoreTableView openTable() {
        AbstractSegmentStoreTableView tableView = this.getTableView();
        if (tableView != null) {
            return tableView;
        }
        IViewPart vp = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        vp = (IViewPart)UIThreadRunnable.syncExec(() -> {
            try {
                return workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.table.TestSegmentStoreTableView");
            }
            catch (PartInitException e) {
                return null;
            }
        });
        Assert.assertNotNull((Object)vp);
        Assert.assertTrue((boolean)(vp instanceof TestSegmentStoreTableView));
        TestSegmentStoreTableView testSegmentStoreTableView = (TestSegmentStoreTableView)vp;
        testSegmentStoreTableView.setTest(this);
        this.fTableView = testSegmentStoreTableView;
        return this.fTableView;
    }

    protected @NonNull ISegment createSegment(long start, long end) {
        return new BasicSegment(start, end);
    }

    @Test
    public void climbTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 0;
        while (i < 100) {
            fixture.add(this.createSegment(i, 2 * i));
            ++i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel(fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"99", (int)0, (int)2));
    }

    @Test
    public void decrementingTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 100;
        while (i >= 0) {
            fixture.add(this.createSegment(i, 2 * i));
            --i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel(fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"100", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"100", (int)0, (int)2));
    }

    @Test
    public void smallTest() {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 1;
        while (i >= 0) {
            fixture.add(this.createSegment(i, 2 * i));
            --i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel(fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1", (int)0, (int)2));
    }

    @Test
    public void largeTest() {
        int size = 1000000;
        ISegment[] fixture = new ISegment[1000000];
        int i = 0;
        while (i < 1000000) {
            fixture[i] = this.createSegment(i, 2 * i);
            ++i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel((Object)fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"999,999", (int)0, (int)2));
    }

    @Test
    public void noiseTest() {
        Random rnd = new Random();
        rnd.setSeed(1234L);
        int size = 1000000;
        ISegment[] fixture = new ISegment[1000000];
        int i = 0;
        while (i < 1000000) {
            int start = Math.abs(rnd.nextInt(100000000));
            int end = start + Math.abs(rnd.nextInt(1000000));
            fixture[i] = this.createSegment(start, end);
            ++i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel((Object)fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"894,633", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"999,999", (int)0, (int)2));
    }

    @Test
    public void gaussianNoiseTest() {
        Random rnd = new Random();
        rnd.setSeed(1234L);
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 1;
        while (i <= 1000000) {
            int start = Math.abs(rnd.nextInt(100000000));
            int delta = Math.abs(rnd.nextInt(1000));
            int end = start + delta * delta;
            fixture.add(this.createSegment(start, end));
            ++i;
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel(fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"400,689", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"998,001", (int)0, (int)2));
    }

    @Test
    public void testWriteToTsv() throws NoSuchMethodException, IOException {
        ArrayList<@NonNull ISegment> fixture = new ArrayList<ISegment>();
        int i = 1;
        while (i <= 20) {
            int start = i;
            int delta = i++;
            int end = start + delta * delta;
            fixture.add(this.createSegment(start, end));
        }
        Assert.assertNotNull((Object)this.getTable());
        this.getTable().updateModel(fixture);
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        SWTBot bot = new SWTBot();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1", (int)0, (int)2));
        SWTWorkbenchBot swtWorkbenchBot = new SWTWorkbenchBot();
        SWTBotView viewBot = swtWorkbenchBot.viewById(this.getTableView().getSite().getId());
        String[] lines = this.extractTsv(viewBot);
        this.testTsv(lines);
        List<String> actionResult = Arrays.asList(lines);
        String absolutePath = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "syscallLatencyTest.testWriteToTsv.tsv";
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{absolutePath});
        SWTBotMenu menuBot = viewBot.viewMenu().menu(new String[]{"Export to TSV"});
        try {
            Assert.assertTrue((boolean)menuBot.isEnabled());
            Assert.assertTrue((boolean)menuBot.isVisible());
            menuBot.click();
            Throwable throwable = null;
            Object var11_16 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(absolutePath));){
                List actual = br.lines().collect(Collectors.toList());
                Assert.assertEquals((String)"Both reads", actionResult, actual);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            new File(absolutePath).delete();
        }
    }

    private String[] extractTsv(SWTBotView viewBot) throws NoSuchMethodException, SecurityException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Assert.assertNotNull((Object)os);
        Class<@NonNull AbstractSegmentStoreTableView> clazz = AbstractSegmentStoreTableView.class;
        Method method = clazz.getDeclaredMethod("exportToTsv", OutputStream.class);
        method.setAccessible(true);
        Exception[] except = new Exception[1];
        UIThreadRunnable.syncExec(() -> {
            try {
                method.invoke((Object)this.getTableView(), os);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                exceptionArray[0] = e;
            }
        });
        Assert.assertNull((Object)except[0]);
        String[] lines = String.valueOf(os).split(System.getProperty("line.separator"));
        return lines;
    }

    protected void testTsv(String[] lines) {
        Assert.assertNotNull((Object)lines);
        Assert.assertEquals((String)"number of lines", (long)21L, (long)lines.length);
        Assert.assertEquals((String)"header", (Object)"Start Time\tEnd Time\tDuration", (Object)lines[0]);
        Assert.assertTrue((String)"line 1", (boolean)lines[1].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s001\\t\\d\\d:\\d\\d:00.000 000 002\\t1"));
        Assert.assertTrue((String)"line 2", (boolean)lines[2].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s002\\t\\d\\d:\\d\\d:00.000 000 006\\t4"));
        Assert.assertTrue((String)"line 3", (boolean)lines[3].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s003\\t\\d\\d:\\d\\d:00.000 000 012\\t9"));
        Assert.assertTrue((String)"line 4", (boolean)lines[4].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s004\\t\\d\\d:\\d\\d:00.000 000 020\\t16"));
        Assert.assertTrue((String)"line 5", (boolean)lines[5].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s005\\t\\d\\d:\\d\\d:00.000 000 030\\t25"));
        Assert.assertTrue((String)"line 6", (boolean)lines[6].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s006\\t\\d\\d:\\d\\d:00.000 000 042\\t36"));
        Assert.assertTrue((String)"line 7", (boolean)lines[7].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s007\\t\\d\\d:\\d\\d:00.000 000 056\\t49"));
        Assert.assertTrue((String)"line 8", (boolean)lines[8].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s008\\t\\d\\d:\\d\\d:00.000 000 072\\t64"));
        Assert.assertTrue((String)"line 9", (boolean)lines[9].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s009\\t\\d\\d:\\d\\d:00.000 000 090\\t81"));
        Assert.assertTrue((String)"line 10", (boolean)lines[10].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s010\\t\\d\\d:\\d\\d:00.000 000 110\\t100"));
        Assert.assertTrue((String)"line 11", (boolean)lines[11].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s011\\t\\d\\d:\\d\\d:00.000 000 132\\t121"));
        Assert.assertTrue((String)"line 12", (boolean)lines[12].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s012\\t\\d\\d:\\d\\d:00.000 000 156\\t144"));
        Assert.assertTrue((String)"line 13", (boolean)lines[13].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s013\\t\\d\\d:\\d\\d:00.000 000 182\\t169"));
        Assert.assertTrue((String)"line 14", (boolean)lines[14].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s014\\t\\d\\d:\\d\\d:00.000 000 210\\t196"));
        Assert.assertTrue((String)"line 15", (boolean)lines[15].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s015\\t\\d\\d:\\d\\d:00.000 000 240\\t225"));
        Assert.assertTrue((String)"line 16", (boolean)lines[16].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s016\\t\\d\\d:\\d\\d:00.000 000 272\\t256"));
        Assert.assertTrue((String)"line 17", (boolean)lines[17].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s017\\t\\d\\d:\\d\\d:00.000 000 306\\t289"));
        Assert.assertTrue((String)"line 18", (boolean)lines[18].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s018\\t\\d\\d:\\d\\d:00.000 000 342\\t324"));
        Assert.assertTrue((String)"line 19", (boolean)lines[19].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s019\\t\\d\\d:\\d\\d:00.000 000 380\\t361"));
        Assert.assertTrue((String)"line 20", (boolean)lines[20].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s020\\t\\d\\d:\\d\\d:00.000 000 420\\t400"));
    }

    protected AbstractSegmentStoreTableView getTableView() {
        return this.fTableView;
    }

    protected void setTableView(AbstractSegmentStoreTableView tableView) {
        this.fTableView = tableView;
    }

    protected AbstractSegmentStoreTableViewer getTable() {
        return this.fTable;
    }

    protected void setTable(AbstractSegmentStoreTableViewer table) {
        this.fTable = table;
    }

    protected ISegmentStoreProvider getSegStoreProvider() {
        ISegmentStoreProvider ssp = this.fSsp;
        if (ssp == null) {
            this.fSsp = ssp = new SimpleSegmentStoreProvider();
        }
        return ssp;
    }

    private final class SimpleSegmentStoreProvider
    implements ISegmentStoreProvider {
        private SimpleSegmentStoreProvider() {
        }

        public void removeListener(@NonNull IAnalysisProgressListener listener) {
        }

        public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
            return SegmentTableTest.this.fSs;
        }

        public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
            return Collections.emptyList();
        }

        public void addListener(@NonNull IAnalysisProgressListener listener) {
        }
    }

    public static final class TestSegmentStoreTableView
    extends AbstractSegmentStoreTableView {
        public static final String ID = "org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.table.TestSegmentStoreTableView";
        SegmentTableTest fTest;

        public void setTest(SegmentTableTest test) {
            this.fTest = test;
        }

        protected @NonNull AbstractSegmentStoreTableViewer createSegmentStoreViewer(@NonNull TableViewer tableViewer) {
            return new AbstractSegmentStoreTableViewer(tableViewer){

                protected @Nullable ISegmentStoreProvider getSegmentStoreProvider(@NonNull ITmfTrace trace) {
                    return fTest.getSegStoreProvider();
                }
            };
        }
    }
}

