/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.tracecompass.common.core.StreamUtils;
import org.junit.Assert;
import org.junit.Test;

public class StreamFlattenerTest {
    @Test
    public void testFlattenTree() {
        TreeNode nodeD = new TreeNode(new TreeNode[0], "D");
        TreeNode nodeE = new TreeNode(new TreeNode[0], "E");
        TreeNode nodeF = new TreeNode(new TreeNode[0], "F");
        TreeNode nodeG = new TreeNode(new TreeNode[0], "G");
        TreeNode nodeB = new TreeNode(new TreeNode[]{nodeD, nodeE}, "B");
        TreeNode nodeC = new TreeNode(new TreeNode[]{nodeF, nodeG}, "C");
        TreeNode nodeA = new TreeNode(new TreeNode[]{nodeB, nodeC}, "A");
        StreamUtils.StreamFlattener sf = new StreamUtils.StreamFlattener(node -> Arrays.stream(node.getChildren()));
        List<String> expected = Arrays.asList("A", "B", "D", "E", "C", "F", "G");
        List results = sf.flatten((Object)nodeA).map(TreeNode::getValue).collect(Collectors.toList());
        Assert.assertEquals(expected, results);
    }

    private static class TreeNode {
        private final TreeNode[] children;
        private final String value;

        public TreeNode(TreeNode[] children, String value) {
            this.children = children;
            this.value = value;
        }

        public TreeNode[] getChildren() {
            return this.children;
        }

        public String getValue() {
            return this.value;
        }
    }
}

