/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSizeFormatTest {
    private static final @NonNull Format FORMAT = DataSizeWithUnitFormat.getInstance();
    private final @NonNull Number fNumValue;
    private final @NonNull String fExpected;

    public DataSizeFormatTest(@NonNull Number value, @NonNull String expected) {
        this.fNumValue = value;
        this.fExpected = expected;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({0, "0"}, {3, "3 B"}, {975, "975 B"}, {1024, "1 KB"}, {0x100000, "1 MB"}, {0x40000000, "1 GB"}, {0x10000000000L, "1 TB"}, {4096, "4 KB"}, {-4096, "-4 KB"}, {4096L, "4 KB"}, {4096.0, "4 KB"}, {12345678, "11.774 MB"}, {Integer.MAX_VALUE, "2 GB"}, {Integer.MIN_VALUE, "-2 GB"}, {Long.MAX_VALUE, "8388608 TB"}, {9.8765432123456E7, "94.19 MB"}, {-9.8765432123456E7, "-94.19 MB"}, {555555555555L, "517.401 GB"}, {555555555555555L, "505.275 TB"});
    }

    protected Format getFormatter() {
        return FORMAT;
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((String)"format value", (Object)this.fExpected, (Object)this.getFormatter().format(this.fNumValue));
    }
}

