/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecimalUnitFormatTest {
    private static final @NonNull Format FORMATTER = new DecimalUnitFormat();
    private final @NonNull Number fNumValue;
    private final @NonNull String fExpected;

    public DecimalUnitFormatTest(@NonNull Number value, @NonNull String expected) {
        this.fNumValue = value;
        this.fExpected = expected;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({0, "0"}, {3, "3"}, {975, "975"}, {1000, "1 k"}, {4000, "4 k"}, {-4000, "-4 k"}, {4000L, "4 k"}, {4000.0, "4 k"}, {12345678, "12.3 M"}, {Integer.MAX_VALUE, "2.1 G"}, {Integer.MIN_VALUE, "-2.1 G"}, {Long.MAX_VALUE, "9223.4 P"}, {9.8765432123456E7, "98.8 M"}, {-9.8765432123456E7, "-98.8 M"}, {555555555555L, "555.6 G"}, {555555555555555L, "555.6 T"}, {100100000, "100.1 M"}, {0.1, "100 m"}, {0.001, "1 m"}, {1.0E-6, "1 \u00b5"}, {1.0E-9, "1 n"}, {1.0E-12, "1 p"}, {-0.04, "-40 m"}, {0.002, "2 m"}, {0.0555, "55.5 m"}, {4.928373928E-4, "492.8 \u00b5"}, {2.51E-7, "251 n"}, {4.3E-11, "43 p"}, {4.5643E-8, "45.6 n"}, {Double.MAX_VALUE, "179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 P"}, {Double.POSITIVE_INFINITY, "\u221e"}, {Double.MIN_NORMAL, "0"}, {Double.NEGATIVE_INFINITY, "-\u221e"}, {Double.NaN, "\ufffd"});
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((String)"format value", (Object)this.fExpected, (Object)FORMATTER.format(this.fNumValue));
    }
}

