/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceWriter;
import org.eclipse.tracecompass.internal.ctf.core.trace.Utils;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CTFTraceWriterTest {
    private static File fTempDir;
    private static final long CLOCK_OFFSET = 1332166405241713987L;
    private static final int TOTAL_NB_EVENTS = 695319;
    private static final long LAST_EVENT_TIME = 1332170692664579801L;
    private static final long STREAM0_FIRST_PACKET_TIME = 1332170682412707899L;
    private static final long STREAM0_FIRST_EVENT_TIME = 1332170682440316151L;
    private static final long STREAM0_LAST_EVENT_TIME = 1332170682702066969L;
    private static final int STREAM0_FIRST_PACKET_NB_EVENTS = 14219;
    private static final long STREAM1_FIRST_PACKET_TIME = 1332170682413269423L;
    private static final int STREAM1_FIRST_PACKET_NB_EVENTS = 8213;
    private static final long STREAM1_FIRST_EVENT_TIME = 1332170682440133097L;
    private static final long STREAM1_FIFTH_PACKET_TIME = 1332170683212426208L;
    private static final long STREAM1_TENTH_PACKET_TIME = 1332170684681762296L;
    private static final long STREAM1_FIFTH_PACKET_FIRST_EVENT_TIME = 1332170682702069762L;
    private static final long STREAM1_TENTH_PACKET_LAST_EVENT_TIME = 1332170685256508077L;
    private static final int NB_EVENTS_SEVERAL_PACKETS = 167585;
    private String fName;
    private long fStartTime;
    private long fEndTime;
    private int fNbEvents;
    private long fFirstEventTime;
    private long fLastEventTime;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getTestParams() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        CTFTraceWriterTest.addParams(params, "WHOLE_TRACE", 0L, Long.MAX_VALUE, 695319, 1332170682440133097L, 1332170692664579801L);
        CTFTraceWriterTest.addParams(params, "NO_EVENTS_USING_INVERTED_TIME", Long.MAX_VALUE, Long.MIN_VALUE, 0, -1L, -1L);
        CTFTraceWriterTest.addParams(params, "STREAM0_FIRST_PACKET_TIME", 1332170682412707899L, 1332170682412707899L, 14219, 1332170682440316151L, 1332170682702066969L);
        CTFTraceWriterTest.addParams(params, "BOTH_STREAMS_FIRST_PACKET_ONLY", 1332170682412707899L, 1332170682413269423L, 22432, 1332170682440133097L, 1332170682702066969L);
        CTFTraceWriterTest.addParams(params, "BOTH_STREAMS_SEVERAL_PACKETS", 1332170683212426208L, 1332170684681762296L, 167585, 1332170682702069762L, 1332170685256508077L);
        return params;
    }

    private static void addParams(List<Object[]> params, String name, long startTime, long endTime, int nbEvents, long firstEventTime, long lastEventTime) {
        Object[] array = new Object[]{name, startTime, endTime, nbEvents, firstEventTime, lastEventTime};
        params.add(array);
    }

    @BeforeClass
    public static void beforeClass() {
        String tempDir;
        String property = System.getProperty("osgi.instance.area");
        File dir = null;
        if (property != null) {
            try {
                dir = URIUtil.toFile((URI)URIUtil.fromString((String)property));
                dir = new File(String.valueOf(dir.getAbsolutePath()) + File.separator);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (dir == null) {
            dir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!(fTempDir = new File(tempDir = String.valueOf(dir.getAbsolutePath()) + File.separator + "testcases" + File.separator)).exists()) {
            fTempDir.mkdirs();
        }
    }

    public CTFTraceWriterTest(String name, long startTime, long endTime, int nbEvents, long firstEventTime, long lastEventTime) {
        this.fName = name;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fNbEvents = nbEvents;
        this.fFirstEventTime = firstEventTime;
        this.fLastEventTime = lastEventTime;
    }

    @Test
    public void testKernelTrace() {
        try {
            CTFTrace trace = CtfTestTraceUtils.getTrace(CtfTestTrace.KERNEL);
            CTFTraceWriter ctfWriter = new CTFTraceWriter((CTFTrace)NonNullUtils.checkNotNull((Object)trace));
            String traceName = CTFTraceWriterTest.createTraceName(this.fName);
            ctfWriter.copyPackets(this.fStartTime, this.fEndTime, traceName);
            File metadata = new File(String.valueOf(traceName) + Utils.SEPARATOR + "metadata");
            Assert.assertTrue((String)"metadata", (boolean)metadata.exists());
            CTFTrace outTrace = new CTFTrace(traceName);
            int count = 0;
            Long start = null;
            long end = 0L;
            Throwable throwable = null;
            Object var11_12 = null;
            try (CTFTraceReader reader = new CTFTraceReader(outTrace);){
                while (reader.hasMoreEvents()) {
                    ++count;
                    IEventDefinition def = reader.getCurrentEventDef();
                    end = def.getTimestamp();
                    if (start == null) {
                        start = outTrace.getClock().getClockOffset() + reader.getStartTime();
                    }
                    reader.advance();
                }
                end = outTrace.getClock().getClockOffset() + end;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (this.fFirstEventTime >= 0L) {
                Assert.assertEquals((String)"first event time", (Object)this.fFirstEventTime, (Object)start);
            }
            if (this.fLastEventTime >= 0L) {
                Assert.assertEquals((String)"last event time", (long)this.fLastEventTime, (long)end);
            }
            Assert.assertEquals((String)this.toString(), (long)this.fNbEvents, (long)count);
            if (this.fNbEvents == 0) {
                Assert.assertFalse((String)"channel0", (boolean)CTFTraceWriterTest.getChannelFile(traceName, 0).exists());
                Assert.assertFalse((String)"channel1", (boolean)CTFTraceWriterTest.getChannelFile(traceName, 1).exists());
            }
        }
        catch (CTFException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static File getChannelFile(String path, int id) {
        File channel = new File(String.valueOf(path) + Utils.SEPARATOR + "channel_" + String.valueOf(id));
        return channel;
    }

    private static String createTraceName(String testCase) {
        return String.valueOf(fTempDir.getAbsolutePath()) + File.separator + testCase.toString();
    }
}

