/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.graph;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class LttngExecutionGraphTest {
    private static final @NonNull String TEST_ANALYSIS_ID = "org.eclipse.tracecompass.lttng2.kernel.core.tests.kernelgraph";

    public ITmfTrace setUpTrace(String traceFile) {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(traceFile);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TmfGraphBuilderModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        return trace;
    }

    @Test
    public void testSchedEvents() {
        ITmfTrace trace = this.setUpTrace("testfiles/graph/sched_only.xml");
        Assert.assertNotNull((Object)trace);
        TmfGraphBuilderModule module = (TmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        TmfGraph graph = module.getGraph();
        Assert.assertNotNull((Object)graph);
        Set workers = graph.getWorkers();
        Assert.assertEquals((long)2L, (long)workers.size());
        for (IGraphWorker worker : workers) {
            Assert.assertTrue((boolean)(worker instanceof LttngWorker));
            LttngWorker lttngWorker = (LttngWorker)worker;
            switch (lttngWorker.getHostThread().getTid()) {
                case 1: {
                    List nodesOf = graph.getNodesOf((IGraphWorker)lttngWorker);
                    Assert.assertEquals((long)4L, (long)nodesOf.size());
                    TmfVertex v = (TmfVertex)nodesOf.get(0);
                    Assert.assertEquals((long)10L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    TmfEdge edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.PREEMPTED, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(1);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)20L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.RUNNING, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(2);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)30L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.PREEMPTED, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(3);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)40L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
                    break;
                }
                case 2: {
                    List nodesOf = graph.getNodesOf((IGraphWorker)lttngWorker);
                    Assert.assertEquals((long)4L, (long)nodesOf.size());
                    TmfVertex v = (TmfVertex)nodesOf.get(0);
                    Assert.assertEquals((long)10L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    TmfEdge edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.RUNNING, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(1);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)20L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.BLOCKED, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(2);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)30L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)TmfEdge.EdgeType.RUNNING, (Object)edge.getType());
                    v = (TmfVertex)nodesOf.get(3);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)40L, (long)v.getTs());
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)v.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)v.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown worker");
                }
            }
        }
    }
}

