/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.synchronization;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class UstKernelSyncTest {
    @Rule
    public TestRule globalTimeout = new Timeout(60L, TimeUnit.SECONDS);
    private static final @NonNull CtfTestTrace KERNEL_TRACE = CtfTestTrace.CONTEXT_SWITCHES_KERNEL;
    private static final @NonNull CtfTestTrace UST_TRACE = CtfTestTrace.CONTEXT_SWITCHES_UST;
    private TmfExperiment fExperiment;
    private ITmfTrace fKernelTrace;
    private ITmfTrace fUstTrace;
    private KernelAnalysisModule fKernelModule;

    @Before
    public void setup() {
        CtfTmfTrace ustTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)UST_TRACE);
        String kernelTracePath = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)KERNEL_TRACE).getPath();
        LttngKernelTrace kernelTrace = new LttngKernelTrace();
        try {
            kernelTrace.initTrace(null, kernelTracePath, CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        TmfExperiment experiment = new TmfExperiment(CtfTmfEvent.class, "test-exp", new ITmfTrace[]{ustTrace, kernelTrace}, 5000, null);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)ustTrace, null));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)kernelTrace, null));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceSelectedSignal((Object)this, (ITmfTrace)experiment));
        KernelAnalysisModule module = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        Assert.assertNotNull((Object)module);
        module.waitForCompletion();
        this.fExperiment = experiment;
        this.fKernelTrace = kernelTrace;
        this.fUstTrace = ustTrace;
        this.fKernelModule = module;
    }

    @After
    public void tearDown() {
        if (this.fExperiment != null) {
            this.fExperiment.dispose();
        }
        if (this.fKernelTrace != null) {
            this.fKernelTrace.dispose();
        }
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)KERNEL_TRACE);
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)UST_TRACE);
    }

    @Test
    public void testOneEvent() {
        TmfExperiment experiment = this.fExperiment;
        ITmfTrace ustTrace = this.fUstTrace;
        KernelAnalysisModule module = this.fKernelModule;
        Assert.assertNotNull((Object)experiment);
        Assert.assertNotNull((Object)ustTrace);
        Assert.assertNotNull((Object)module);
        Predicate<@NonNull ITmfEvent> eventFinder = event -> {
            Long addr = (Long)event.getContent().getFieldValue(Long.class, new String[]{"addr"});
            Long cs = (Long)event.getContent().getFieldValue(Long.class, new String[]{"call_site"});
            Long ctxVtid = (Long)event.getContent().getFieldValue(Long.class, new String[]{"context._vtid"});
            if (addr == null || cs == null || ctxVtid == null) {
                return false;
            }
            return Objects.equals(event.getType().getName(), "lttng_ust_cyg_profile:func_entry") && Objects.equals(Long.toHexString(addr), "804af97") && Objects.equals(Long.toHexString(cs), "804ab03") && Objects.equals((long)ctxVtid, 594L);
        };
        CtfTmfEvent ustEvent = (CtfTmfEvent)TmfTraceUtils.getNextEventMatching((ITmfTrace)experiment, (long)0L, eventFinder, null);
        Assert.assertNotNull((Object)ustEvent);
        long rank = experiment.seekEvent(ustEvent.getTimestamp()).getRank() + 1L;
        ustEvent = (CtfTmfEvent)TmfTraceUtils.getNextEventMatching((ITmfTrace)experiment, (long)rank, eventFinder, null);
        Assert.assertNotNull((Object)ustEvent);
        Assert.assertEquals((Object)ustTrace, (Object)ustEvent.getTrace());
        Integer tidFromKernel = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)ustEvent.getCPU(), (long)ustEvent.getTimestamp().toNanos());
        Assert.assertNotNull((Object)tidFromKernel);
        Assert.assertEquals((long)594L, (long)tidFromKernel.intValue());
    }

    @Test
    public void testWholeUstTrace() {
        TmfExperiment experiment = this.fExperiment;
        ITmfTrace ustTrace = this.fUstTrace;
        KernelAnalysisModule module = this.fKernelModule;
        Assert.assertNotNull((Object)experiment);
        Assert.assertNotNull((Object)ustTrace);
        Assert.assertNotNull((Object)module);
        ITmfContext context = ustTrace.seekEvent(0L);
        CtfTmfEvent ustEvent = (CtfTmfEvent)ustTrace.getNext(context);
        int count = 0;
        while (ustEvent != null) {
            Long ustVtid = (Long)ustEvent.getContent().getFieldValue(Long.class, new String[]{"context._vtid"});
            Assert.assertNotNull((Object)ustVtid);
            long ts = ustEvent.getTimestamp().toNanos();
            long cpu = ustEvent.getCPU();
            Integer kernelTid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)cpu, (long)ts);
            Assert.assertNotNull((Object)kernelTid);
            Assert.assertEquals((String)("Wrong TID for trace event " + ustEvent.toString()), (long)ustVtid, (long)kernelTid.longValue());
            ustEvent = (CtfTmfEvent)ustTrace.getNext(context);
            ++count;
        }
        Assert.assertEquals((long)UST_TRACE.getNbEvents(), (long)count);
    }
}

