/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.EventContextHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.TraceEventHandlerExecutionGraph;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.TraceEventHandlerSched;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.TraceEventHandlerStatedump;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngSystemModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class LttngKernelExecGraphProvider
extends AbstractTmfGraphProvider {
    private final LttngSystemModel fSystem = new LttngSystemModel();

    public LttngKernelExecGraphProvider(ITmfTrace trace) {
        super(trace, "LTTng Kernel");
        this.registerHandler((ITraceEventHandler)new TraceEventHandlerStatedump(this));
        this.registerHandler((ITraceEventHandler)new TraceEventHandlerSched(this));
        this.registerHandler((ITraceEventHandler)new EventContextHandler(this));
        this.registerHandler((ITraceEventHandler)new TraceEventHandlerExecutionGraph(this));
    }

    public void done() {
        TmfGraph graph = this.getAssignedGraph();
        if (graph == null) {
            throw new NullPointerException();
        }
        Set keys = graph.getWorkers();
        ArrayList<LttngWorker> kernelWorker = new ArrayList<LttngWorker>();
        for (Object e : keys) {
            LttngWorker w;
            if (!(e instanceof LttngWorker) || (w = (LttngWorker)e).getHostThread().getTid() != -1) continue;
            kernelWorker.add(w);
        }
        for (LttngWorker lttngWorker : kernelWorker) {
            List nodes = graph.getNodesOf((IGraphWorker)lttngWorker);
            for (TmfVertex node : nodes) {
                TmfVertex next;
                TmfEdge nextV;
                TmfEdge nextH = node.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                TmfEdge inV = node.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
                if (inV == null || nextH == null || (nextV = (next = nextH.getVertexTo()).getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE)) == null) continue;
                TmfVertex src = inV.getVertexFrom();
                TmfVertex dst = nextV.getVertexTo();
                node.removeEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
                next.removeEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE);
                src.linkVertical(dst).setType(inV.getType());
            }
        }
    }

    public IKernelAnalysisEventLayout getEventLayout(ITmfTrace trace) {
        if (trace instanceof LttngKernelTrace) {
            return ((LttngKernelTrace)trace).getKernelEventLayout();
        }
        return LttngEventLayout.getInstance();
    }

    public LttngSystemModel getSystem() {
        return this.fSystem;
    }

    public static enum Context {
        NONE,
        SOFTIRQ,
        IRQ,
        HRTIMER,
        IPI;

    }

    public static enum ProcessStatus {
        UNKNOWN(0),
        WAIT_FORK(1),
        WAIT_CPU(2),
        EXIT(3),
        ZOMBIE(4),
        WAIT_BLOCKED(5),
        RUN(6),
        DEAD(7);

        private final int fValue;

        private ProcessStatus(int value) {
            this.fValue = value;
        }

        private int value() {
            return this.fValue;
        }

        public static ProcessStatus getStatus(long val) {
            ProcessStatus[] processStatusArray = ProcessStatus.values();
            int n = processStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessStatus e = processStatusArray[n2];
                if ((long)e.value() == val) {
                    return e;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

