/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keyboard;
import org.eclipse.swtbot.swt.finder.keyboard.KeyboardFactory;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTimeGraphViewTestBase;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlFlowViewTest
extends KernelTimeGraphViewTestBase {
    private static final String CHECK_SELECTED = "Check selected";
    private static final String CHECK_ALL = "Check all";
    private static final String CHECK_SUBTREE = "Check subtree";
    private static final String CHECK_ACTIVE = "Check Active";
    private static final String UNCHECK_SELECTED = "Uncheck selected";
    private static final String UNCHECK_ALL = "Uncheck all";
    private static final String UNCHECK_SUBTREE = "Uncheck subtree";
    private static final String UNCHECK_INACTIVE = "Uncheck Inactive";
    private static final String FOLLOW_CPU_BACKWARD = "Follow CPU Backward";
    private static final String FOLLOW_CPU_FORWARD = "Follow CPU Forward";
    private static final String SELECT_PREVIOUS_STATE_CHANGE = "Select Previous State Change";
    private static final String SELECT_NEXT_STATE_CHANGE = "Select Next State Change";
    private static final String SELECT_NEXT_PROCESS = "Select Next Process";
    private static final Keyboard KEYBOARD = KeyboardFactory.getSWTKeyboard();
    private static final @NonNull ITmfTimestamp START_TIME = TmfTimestamp.fromNanos((long)1368000272650993664L);
    private static final @NonNull ITmfTimestamp TID1_TIME1 = TmfTimestamp.fromNanos((long)1368000272651208412L);
    private static final @NonNull ITmfTimestamp TID1_TIME2 = TmfTimestamp.fromNanos((long)1368000272656147616L);
    private static final @NonNull ITmfTimestamp TID1_TIME3 = TmfTimestamp.fromNanos((long)1368000272656362364L);
    private static final @NonNull ITmfTimestamp TID1_TIME4 = TmfTimestamp.fromNanos((long)1368000272663234300L);
    private static final @NonNull ITmfTimestamp TID1_TIME5 = TmfTimestamp.fromNanos((long)1368000272663449048L);
    private static final @NonNull ITmfTimestamp TID1_TIME6 = TmfTimestamp.fromNanos((long)1368000272665596528L);
    private static final @NonNull ITmfTimestamp TID2_TIME1 = TmfTimestamp.fromNanos((long)1368000272651852656L);
    private static final @NonNull ITmfTimestamp TID2_TIME2 = TmfTimestamp.fromNanos((long)1368000272652067404L);
    private static final @NonNull ITmfTimestamp TID2_TIME3 = TmfTimestamp.fromNanos((long)1368000272652282152L);
    private static final @NonNull ITmfTimestamp TID2_TIME4 = TmfTimestamp.fromNanos((long)1368000272652496900L);
    private static final @NonNull ITmfTimestamp TID5_TIME1 = TmfTimestamp.fromNanos((long)1368000272652496900L);
    private SWTBotView fViewBot;

    @Override
    protected SWTBotView getViewBot() {
        return this.fViewBot;
    }

    @Override
    protected List<String> getLegendValues() {
        return Arrays.asList("UNKNOWN", "WAIT_UNKNOWN", "WAIT_BLOCKED", "WAIT_FOR_CPU", "USERMODE", "SYSCALL", "INTERRUPTED");
    }

    @Override
    protected List<String> getToolbarTooltips() {
        return Arrays.asList("Align Views", "Optimize", "", "Show View Filters", "Show Legend", "", "Reset the Time Scale to Default", SELECT_PREVIOUS_STATE_CHANGE, SELECT_NEXT_STATE_CHANGE, "", "Add Bookmark...", "Previous Marker", "Next Marker", "", "Select Previous Process", SELECT_NEXT_PROCESS, "Zoom In", "Zoom Out", "", "Hide Arrows", FOLLOW_CPU_BACKWARD, FOLLOW_CPU_FORWARD, "Go to previous event of the selected thread", "Go to next event of the selected thread");
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.fViewBot = fBot.viewByTitle("Control Flow");
        this.fViewBot.show();
        this.fViewBot.setFocus();
    }

    @Test
    public void testKeyboardLeftRight() {
        this.testNextPreviousEvent(() -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT}));
    }

    @Test
    public void testToolBarSelectNextPreviousStateChange() {
        this.testNextPreviousEvent(() -> {
            SWTBotToolbarButton sWTBotToolbarButton = this.fViewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = this.fViewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click(131072);
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = this.fViewBot.toolbarButton(SELECT_PREVIOUS_STATE_CHANGE).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = this.fViewBot.toolbarButton(SELECT_PREVIOUS_STATE_CHANGE).click(131072);
        });
    }

    private void testNextPreviousEvent(Runnable selectNext, Runnable shiftSelectNext, Runnable selectPrevious, Runnable shiftSelectPrevious) {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        SWTBotUtils.pressShortcutGoToTreeTop((Keyboard)KEYBOARD);
        this.fViewBot.toolbarButton(SELECT_NEXT_PROCESS).click();
        final TimeGraphControl timegraph = (TimeGraphControl)this.fViewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                timegraph.setFocus();
            }
        });
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME2, TID1_TIME2));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME3)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME3));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME4));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME5));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME6));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME6)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME6));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME5));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME4));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME2));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME2)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME2));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME4)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME4));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME3));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME2));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME1)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME2));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME3));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME5));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME5)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME5));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME2, TID1_TIME2));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    @Test
    public void testFilter() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(1000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        SWTBotToolbarButton filterButton = this.fViewBot.toolbarButton("Show View Filters");
        filterButton.click();
        fBot.waitUntil(Conditions.shellIsActive((String)"Filter"));
        SWTBot bot = fBot.activeShell().bot();
        SWTBotTree treeBot = bot.tree();
        KernelTestBase.TreeCheckedCounter treeCheckCounter = new KernelTestBase.TreeCheckedCounter(treeBot);
        Integer checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)"default", (long)226L, (long)checked.intValue());
        bot.button(UNCHECK_ALL).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((long)0L, (long)checked.intValue());
        bot.button(CHECK_ACTIVE).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)CHECK_ACTIVE, (long)69L, (long)checked.intValue());
        bot.button(CHECK_ALL).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)CHECK_ALL, (long)226L, (long)checked.intValue());
        bot.button(UNCHECK_INACTIVE).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)UNCHECK_INACTIVE, (long)69L, (long)checked.intValue());
        treeBot.getTreeItem(LttngTraceGenerator.getName()).select("gnuplot");
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SELECTED).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)CHECK_SELECTED, (long)2L, (long)checked.intValue());
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SUBTREE).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)CHECK_SUBTREE, (long)2L, (long)checked.intValue());
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SELECTED).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)225L, (long)checked.intValue());
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SUBTREE).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)225L, (long)checked.intValue());
        bot.button(UNCHECK_ALL).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((long)0L, (long)checked.intValue());
        bot.text().setText("half-life 3");
        SWTBotTreeItem treeItem = treeBot.getTreeItem(LttngTraceGenerator.getName());
        treeItem.rowCount();
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)treeItem, (int)25));
        bot.button(CHECK_ALL).click();
        checked = (Integer)UIThreadRunnable.syncExec((Result)treeCheckCounter);
        Assert.assertEquals((String)"Filtered", (long)26L, (long)checked.intValue());
        bot.button("OK").click();
        treeBot = this.fViewBot.bot().tree();
        treeItem = treeBot.getTreeItem(LttngTraceGenerator.getName());
        int i = 0;
        while (i < 25) {
            Assert.assertEquals((String)"Filtered Control flow view", (Object)"Half-life 3", (Object)treeItem.cell(i, 0));
            ++i;
        }
    }

    @Test
    public void testToolBarFollowCPUForwardBackward() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        SWTBotTree tree = this.fViewBot.bot().tree();
        SWTBotUtils.pressShortcutGoToTreeTop((Keyboard)KEYBOARD);
        this.fViewBot.toolbarButton(SELECT_NEXT_PROCESS).click();
        final TimeGraphControl timegraph = (TimeGraphControl)this.fViewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                timegraph.setFocus();
            }
        });
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME1, TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME2)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID5_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"5"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID5_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME3)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID1_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID1_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"1"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME4)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME4));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME1, TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    private void timeGraphIsReadyCondition(@NonNull TmfTimeRange selectionRange) {
        IWorkbenchPart part = this.fViewBot.getViewReference().getPart(false);
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)part), (TmfTimeRange)selectionRange, (ITmfTimestamp)selectionRange.getEndTime()));
    }
}

