/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keyboard;
import org.eclipse.swtbot.swt.finder.keyboard.KeyboardFactory;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class FindDialogTestBase
extends KernelTestBase {
    private static final Keyboard KEYBOARD = KeyboardFactory.getSWTKeyboard();
    private static final @NonNull ITmfTimestamp START_TIME = TmfTimestamp.create((long)1368000272650993664L, (int)-9);
    private static final @NonNull String SPACE = " ";
    private static final String REGEX_PREFIX = "\\A";
    private static final String DIALOG_TITLE = "Find";
    private String fFindText;
    private SWTBotView fViewBot;
    private static int fSelectionIndex;

    protected abstract String getViewTitle();

    protected abstract String getFindText();

    @Before
    public void init() {
        String title = this.getViewTitle();
        this.fViewBot = fBot.viewByTitle(title);
        this.fViewBot.show();
        this.fViewBot.setFocus();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)this.fViewBot.getViewReference().getPart(false)), (TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME), (ITmfTimestamp)START_TIME));
        FindDialogTestBase.openDialog(this.fViewBot);
        this.fFindText = this.getFindText();
    }

    @After
    public void afterTest() {
        FindDialogTestBase.closeDialog(FindDialogTestBase.getDialogBot());
    }

    private static void openDialog(SWTBotView view) {
        view.setFocus();
        SWTBotUtils.pressShortcutGoToTreeTop((Keyboard)KEYBOARD);
        if (SWTUtils.isMac()) {
            KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.COMMAND, KeyStroke.getInstance((int)70)});
        } else {
            KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.CTRL, KeyStroke.getInstance((int)70)});
        }
        fBot.waitUntil(Conditions.shellIsActive((String)DIALOG_TITLE));
    }

    @Test
    public void testWrapSearch() {
        SWTBot bot = FindDialogTestBase.getDialogBot();
        SWTBotButton findButton = bot.button(DIALOG_TITLE);
        SearchOptions options = this.getOptions(false, false, true, false, false);
        FindDialogTestBase.search(this.fFindText, options, findButton, bot);
        Assert.assertTrue((boolean)FindDialogTestBase.isWrapped(bot));
        FindDialogTestBase.verifySelection(this.fFindText, options, this.fViewBot, FindDialogTestBase.isWrapped(bot));
        options = this.getOptions(true, false, true, false, false);
        FindDialogTestBase.search(this.fFindText, options, findButton, bot);
        Assert.assertTrue((boolean)FindDialogTestBase.isWrapped(bot));
    }

    @Test
    public void testDirection() {
        SWTBot bot = FindDialogTestBase.getDialogBot();
        SWTBotButton findButton = bot.button(DIALOG_TITLE);
        this.testDirectionSearch(true, this.fFindText, bot, findButton, this.fViewBot);
        this.testDirectionSearch(false, this.fFindText, bot, findButton, this.fViewBot);
    }

    private void testDirectionSearch(boolean forward, String findText, SWTBot bot, SWTBotButton findButton, SWTBotView view) {
        SearchOptions options = this.getOptions(forward, false, true, false, false);
        fSelectionIndex = FindDialogTestBase.getSelectionIndex(view);
        FindDialogTestBase.search(findText, options, findButton, bot);
        FindDialogTestBase.verifySelection(findText, options, view, FindDialogTestBase.isWrapped(bot));
    }

    @Test
    public void testCaseSensitive() {
        SWTBot bot = FindDialogTestBase.getDialogBot();
        SWTBotButton findButton = bot.button(DIALOG_TITLE);
        SearchOptions options = this.getOptions(true, true, false, false, false);
        FindDialogTestBase.search(this.fFindText, options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, true);
        FindDialogTestBase.search(this.fFindText.toLowerCase(), options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, false);
    }

    @Test
    public void testWholeWord() {
        SWTBot bot = FindDialogTestBase.getDialogBot();
        SWTBotButton findButton = bot.button(DIALOG_TITLE);
        @NonNull String text = this.fFindText.split(SPACE)[0];
        System.out.println("Reg ex : " + text);
        SearchOptions options = this.getOptions(true, false, false, true, false);
        FindDialogTestBase.search(text, options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, true);
        FindDialogTestBase.search(text.substring(0, text.length() - 1), options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, false);
    }

    @Test
    public void testRegEx() {
        SWTBot bot = FindDialogTestBase.getDialogBot();
        SWTBotButton findButton = bot.button(DIALOG_TITLE);
        String text = REGEX_PREFIX + this.fFindText.split(SPACE)[0];
        System.out.println("Reg ex : " + text);
        SearchOptions options = this.getOptions(true, false, false, false, true);
        FindDialogTestBase.search(text, options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, true);
        options = this.getOptions(true, false, false, false, false);
        FindDialogTestBase.search(text, options, findButton, bot);
        FindDialogTestBase.verifyStatusLabel(bot, false);
    }

    @Test
    public void testOpenCloseDialog() {
        SWTBotShell shell = FindDialogTestBase.getDialogShell();
        FindDialogTestBase.closeDialog(FindDialogTestBase.getDialogBot());
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        FindDialogTestBase.openDialog(this.fViewBot);
    }

    private static void verifyStatusLabel(SWTBot bot, boolean shouldBeFound) {
        SWTBotLabel statusLabel = bot.label(1);
        Assert.assertTrue((String)"status label", (shouldBeFound == !statusLabel.getText().equals("Entry not found") ? 1 : 0) != 0);
    }

    private static SWTBot getDialogBot() {
        return FindDialogTestBase.getDialogShell().bot();
    }

    private static SWTBotShell getDialogShell() {
        return fBot.shell(DIALOG_TITLE);
    }

    private static void closeDialog(SWTBot bot) {
        bot.button("Close").click();
    }

    private static void search(String findText, SearchOptions options, SWTBotButton findButton, SWTBot bot) {
        SWTBotCombo findFieldCombo = bot.comboBox();
        findFieldCombo.setText(findText);
        Assert.assertTrue((String)"Find combo", (boolean)findFieldCombo.getText().equals(findText));
        SWTBotRadio directions = options.forwardSearch ? bot.radio("Forward").click() : bot.radio("Backward").click();
        Assert.assertTrue((String)"direction", (boolean)directions.isSelected());
        FindDialogTestBase.setCheckButton("Case sensitive", options.caseSensitive, bot);
        FindDialogTestBase.setCheckButton("Wrap search", options.wrapSearch, bot);
        FindDialogTestBase.setCheckButton("Whole word", options.wholeWord, bot);
        FindDialogTestBase.setCheckButton("Regular expression", options.regExSearch, bot);
        findButton.click();
    }

    private SearchOptions getOptions(boolean forward, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regEx) {
        SearchOptions options = new SearchOptions();
        options.forwardSearch = forward;
        options.caseSensitive = caseSensitive;
        options.wrapSearch = wrapSearch;
        options.wholeWord = wholeWord;
        options.regExSearch = regEx;
        return options;
    }

    private static void setCheckButton(String mnemonic, boolean option, SWTBot bot) {
        SWTBotCheckBox checkBox = bot.checkBox(mnemonic);
        if (checkBox.isEnabled()) {
            if (option) {
                checkBox.select();
            } else {
                checkBox.deselect();
            }
        }
    }

    private static void verifySelection(String name, SearchOptions options, SWTBotView view, boolean isWrapped) {
        String entryName = FindDialogTestBase.getTimegraphSelectionName(view);
        Assert.assertTrue((String)"entry name", (entryName != null && entryName.contains(name) ? 1 : 0) != 0);
        int selectionIndex = FindDialogTestBase.getSelectionIndex(view);
        if (!isWrapped) {
            Assert.assertTrue((String)"selection index", (boolean)(options.forwardSearch ? selectionIndex > fSelectionIndex : selectionIndex < fSelectionIndex));
        } else {
            Assert.assertTrue((String)"selection index", (boolean)(options.forwardSearch ? selectionIndex <= fSelectionIndex : selectionIndex >= fSelectionIndex));
        }
        fSelectionIndex = selectionIndex;
    }

    private static boolean isWrapped(SWTBot bot) {
        return bot.label(1).getText().equals("Wrapped search");
    }

    private static String getTimegraphSelectionName(SWTBotView view) {
        TimeGraphControl timegraph = (TimeGraphControl)view.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        return (String)UIThreadRunnable.syncExec(() -> {
            ITimeGraphEntry entry = timegraph.getSelectedTrace();
            if (entry != null) {
                return entry.getName();
            }
            return null;
        });
    }

    private static Integer getSelectionIndex(SWTBotView viewBot) {
        TimeGraphControl timegraph = (TimeGraphControl)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        return (Integer)UIThreadRunnable.syncExec(() -> timegraph.getSelectedIndex());
    }

    private class SearchOptions {
        boolean forwardSearch;
        boolean caseSensitive;
        boolean wrapSearch;
        boolean wholeWord;
        boolean regExSearch;

        private SearchOptions() {
        }
    }
}

