/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class KernelTimeGraphViewTestBase
extends KernelTestBase {
    protected static final String SEPARATOR = "";

    protected abstract SWTBotView getViewBot();

    protected abstract List<String> getToolbarTooltips();

    protected abstract List<String> getLegendValues();

    @Test
    public void testToolbar() {
        List buttons = this.getViewBot().getToolbarButtons();
        List<String> tooltipsExpected = this.getToolbarTooltips();
        ArrayList<String> tooltips = new ArrayList<String>();
        for (SWTBotToolbarButton button : buttons) {
            tooltips.add(button.getToolTipText());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " enabled"), (boolean)button.isEnabled());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " visible"), (boolean)button.isVisible());
        }
        Assert.assertEquals(tooltipsExpected, tooltips);
    }

    @Test
    public void testLegend() {
        List<String> labelValues = this.getLegendValues();
        SWTBotToolbarButton legendButton = this.getViewBot().toolbarButton("Show Legend");
        legendButton.click();
        fBot.waitUntil(Conditions.shellIsActive((String)"States Transition Visualizer"));
        SWTBot bot = fBot.activeShell().bot();
        int i = 1;
        while (i <= labelValues.size()) {
            SWTBotLabel label = bot.label(i);
            Assert.assertNotNull((Object)label);
            Assert.assertEquals((Object)labelValues.get(i - 1), (Object)label.getText());
            ++i;
        }
        bot.button("OK").click();
    }
}

