/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MemoryUsageViewTest {
    private static final int EXPECTED_NUM_SERIES = 4;
    private static final String UST_ID = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static final String PROJECT_NAME = "TestForMemory";
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        CtfTestTrace cygProfile = CtfTestTrace.MEMORY_ANALYSIS;
        File file = new File(CtfTmfTestTraceUtils.getTrace((CtfTestTrace)cygProfile).getPath());
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)file.getAbsolutePath(), (String)UST_ID);
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.lttng2.ust.memoryusage");
        WaitUtils.waitForJobs();
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testOpenMemoryUsage() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.lttng2.ust.memoryusage");
        viewBot.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)viewBot.bot().widget(matcher);
        fBot.waitUntil(ConditionHelpers.numberOfSeries((Chart)chart, (int)4));
        ISeriesSet seriesSet = chart.getSeriesSet();
        ISeries[] series = seriesSet.getSeries();
        int i = 0;
        while (i < series.length) {
            Assert.assertTrue((boolean)(series[i] instanceof ILineSeries));
            ++i;
        }
    }
}

