/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileOpenFailTest {
    @Test
    public void FileOpenBadPcapTest() throws IOException {
        PcapTestTrace trace = PcapTestTrace.BAD_PCAPFILE;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PcapFile file = new PcapFile(trace.getPath());){
                Assert.fail((String)"The pcap was accepted even though the magic number is invalid!");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BadPcapFileException e) {
            Assert.assertEquals((Object)"c3d4a1b2 is not a known magic number.", (Object)e.getMessage());
        }
    }

    @Test
    public void FileOpenBinaryFile() throws IOException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_TRACE;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PcapFile file = new PcapFile(trace.getPath());){
                Assert.fail((String)"The file was accepted even though it is not a pcap file!");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BadPcapFileException e) {
            Assert.assertEquals((Object)"c11ffcc1 is not a known magic number.", (Object)e.getMessage());
        }
    }

    @Test
    public void FileOpenDirectory() throws IOException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_DIRECTORY;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PcapFile file = new PcapFile(trace.getPath());){
                Assert.fail((String)"The file was accepted even though it is not a pcap file!");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BadPcapFileException e) {
            Assert.assertEquals((Object)"Bad Pcap File.", (Object)e.getMessage());
        }
    }
}

