/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.store;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.ArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.LazyArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.treemap.TreeMapStore;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=Parameterized.class)
public class SegmentStoreBenchmark {
    private final ISegmentStore<@NonNull ISegment> fSegStore;
    private final String fName;
    private static final Format FORMAT = new DecimalFormat("###,###.##");

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Array list store", new ArrayListStore()}, {"Lazy array list store", new LazyArrayListStore()}, {"Treemap store", new TreeMapStore()});
    }

    public SegmentStoreBenchmark(String name, ISegmentStore<@NonNull ISegment> segStore) {
        this.fSegStore = segStore;
        this.fName = name;
    }

    protected long getSegmentStoreSize() {
        return 1000000L;
    }

    @Test
    public void test1AddInOrder() {
        int size = 1;
        int[] fuzz = new int[1];
        this.run(size, fuzz, new Object(){}.getClass().getEnclosingMethod().getName());
    }

    @Test
    public void test2AddFuzzyOrder() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.run(size, fuzz, name);
    }

    @Test
    public void test3AddFuzzyOrderThenIterate() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterate(size, fuzz, name);
    }

    @Test
    public void test4AddFuzzyOrderThenIterateThenAddThenIterate() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterateAddIterate(size, fuzz, name);
    }

    @Test
    public void test5AddRandomOrder() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = Math.abs(rng.nextInt());
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterate(size, fuzz, name);
    }

    @Test
    public void test6AddRandomOrderThenIterate() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = Math.abs(rng.nextInt());
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterate(size, fuzz, name);
    }

    @Test
    public void test7AddRandomOrderThenIterateThenAddThenIterate() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterateAddIterate(size, fuzz, name);
    }

    @Test
    public void test8AddFuzzyOrderThenIterateByStartTime() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterateCompare(size, fuzz, name, SegmentComparators.INTERVAL_START_COMPARATOR);
    }

    @Test
    public void test9AddFuzzyOrderThenIterateByEndTime() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterateCompare(size, fuzz, name, SegmentComparators.INTERVAL_END_COMPARATOR);
    }

    @Test
    public void testAAddFuzzyOrderThenIterateByDuration() {
        int size = 1000;
        int[] fuzz = new int[size];
        Random rng = new Random(10L);
        int i = 0;
        while (i < size) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        String name = new Object(){}.getClass().getEnclosingMethod().getName();
        Assert.assertNotNull((Object)name);
        this.runIterateCompare(size, fuzz, name, SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
    }

    private void runIterateCompare(int size, int[] fuzz, String method, @NonNull Comparator<@NonNull ISegment> comparator) {
        long start = System.nanoTime();
        this.populate(size, fuzz, this.fSegStore);
        long startTime = fuzz[0];
        long endTime = this.fSegStore.size() - 1 + fuzz[this.fSegStore.size() % size];
        SegmentStoreBenchmark.iterateCompare(startTime, endTime, this.fSegStore, comparator);
        long end = System.nanoTime();
        long duration = end - start;
        this.outputResults(duration, method);
    }

    private void run(int size, int[] fuzz, String method) {
        long duration = this.populate(size, fuzz, this.fSegStore);
        this.outputResults(duration, method);
    }

    private long populate(int size, int[] fuzz, ISegmentStore<@NonNull ISegment> store) {
        store.clear();
        long start = System.nanoTime();
        SegmentStoreBenchmark.populate(size, fuzz, store, this.getSegmentStoreSize());
        long end = System.nanoTime();
        return end - start;
    }

    private void runIterate(int size, int[] fuzz, String method) {
        long duration = this.addAndIterate(size, fuzz, this.fSegStore);
        this.outputResults(duration, method);
    }

    private long addAndIterate(int size, int[] fuzz, ISegmentStore<@NonNull ISegment> store) {
        long start = System.nanoTime();
        this.populate(size, fuzz, store);
        SegmentStoreBenchmark.iterate(store);
        long end = System.nanoTime();
        return end - start;
    }

    private void runIterateAddIterate(int size, int[] fuzz, String method) {
        long duration = SegmentStoreBenchmark.runIterateAddIterate(size, fuzz, this.fSegStore);
        this.outputResults(duration, method);
    }

    private static long runIterateAddIterate(int size, int[] fuzz, ISegmentStore<@NonNull ISegment> store) {
        long startTime;
        store.clear();
        long start = System.nanoTime();
        int i = 0;
        while (i < 50000) {
            startTime = i + fuzz[i % size];
            store.add((Object)new BasicSegment(startTime, startTime + 10L));
            ++i;
        }
        SegmentStoreBenchmark.iterate(store);
        i = 50000;
        while (i < 100000) {
            startTime = i + fuzz[i % size];
            store.add((Object)new BasicSegment(startTime, startTime + 10L));
            ++i;
        }
        SegmentStoreBenchmark.iterate(store);
        long end = System.nanoTime();
        return end - start;
    }

    private static Object iterate(ISegmentStore<@NonNull ISegment> store) {
        ISegment shutupCompilerWarnings = null;
        Iterator iterator = store.iterator();
        while (iterator.hasNext()) {
            ISegment elem;
            shutupCompilerWarnings = elem = (ISegment)iterator.next();
        }
        return shutupCompilerWarnings;
    }

    private static Object iterateCompare(long startTime, long endTime, ISegmentStore<@NonNull ISegment> store, @NonNull Comparator<@NonNull ISegment> comparator) {
        ISegment shutupCompilerWarnings = null;
        Iterator iterator = store.getIntersectingElements(startTime, endTime, comparator).iterator();
        while (iterator.hasNext()) {
            ISegment elem;
            shutupCompilerWarnings = elem = (ISegment)iterator.next();
        }
        return shutupCompilerWarnings;
    }

    private static void populate(int size, int[] fuzz, ISegmentStore<@NonNull ISegment> store, long count) {
        int i = 0;
        while ((long)i < count) {
            long start = (long)i + (long)fuzz[i % size];
            store.add((Object)new BasicSegment(start, start + 10L));
            ++i;
        }
    }

    private void outputResults(long duration, String method) {
        System.out.println(String.valueOf(this.fName) + ": Time taken for test " + method + ": " + FORMAT.format(duration));
    }
}

