/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.arraylist;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

public class ArrayListStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private final Comparator<E> COMPARATOR = Ordering.from(SegmentComparators.INTERVAL_START_COMPARATOR).compound(SegmentComparators.INTERVAL_END_COMPARATOR);
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final List<E> fStore = new ArrayList();
    private transient @Nullable Iterable<E> fLastSnapshot = null;

    public ArrayListStore() {
    }

    public ArrayListStore(Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ISegment) {
                this.fStore.add((ISegment)array[i]);
            }
            ++i;
        }
        this.fStore.sort(this.COMPARATOR);
    }

    @Override
    public Iterator<E> iterator() {
        this.fLock.readLock().lock();
        try {
            ImmutableList lastSnapshot = this.fLastSnapshot;
            if (lastSnapshot == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add null value");
        }
        this.fLock.writeLock().lock();
        try {
            int insertPoint = Collections.binarySearch(this.fStore, val);
            insertPoint = insertPoint >= 0 ? insertPoint : -insertPoint - 1;
            this.fStore.add(insertPoint, val);
            this.fLastSnapshot = null;
            return true;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.fLock.readLock().lock();
        try {
            int n = this.fStore.size();
            return n;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.isEmpty();
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(@Nullable Object o) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.contains(o);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.containsAll(c);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.fLock.readLock().lock();
        try {
            Object[] objectArray = this.fStore.toArray();
            return objectArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fLock.readLock().lock();
        try {
            T[] TArray = this.fStore.toArray(a);
            return TArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.fLock.writeLock().lock();
        try {
            this.fStore.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.readLock().lock();
        try {
            int index = Collections.binarySearch(this.fStore, new BasicSegment(end, Long.MAX_VALUE));
            index = index >= 0 ? index : -index - 1;
            Iterable iterable = this.fStore.subList(0, index).stream().filter(element -> start <= element.getEnd() && end >= element.getStart()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.fLock.writeLock().lock();
        try {
            this.fStore.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }
}

