/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.treemap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

public class TreeMapStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final TreeMultimap<Long, E> fStartTimesIndex = TreeMultimap.create(SegmentComparators.LONG_COMPARATOR, (Comparator)Ordering.from(SegmentComparators.INTERVAL_END_COMPARATOR).compound((Comparator)Ordering.natural()));
    private final TreeMultimap<Long, E> fEndTimesIndex = TreeMultimap.create(SegmentComparators.LONG_COMPARATOR, (Comparator)Ordering.from(SegmentComparators.INTERVAL_START_COMPARATOR).compound((Comparator)Ordering.natural()));
    private volatile long fSize = 0L;
    private transient @Nullable Iterable<E> fLastSnapshot = null;

    @Override
    public Iterator<E> iterator() {
        this.fLock.readLock().lock();
        try {
            ImmutableList lastSnapshot = this.fLastSnapshot;
            if (lastSnapshot == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf((Collection)this.fStartTimesIndex.values());
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            if (this.fStartTimesIndex.put((Object)val.getStart(), val)) {
                this.fEndTimesIndex.put((Object)val.getEnd(), val);
                ++this.fSize;
                this.fLastSnapshot = null;
                return true;
            }
            return false;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return Long.valueOf(this.fSize).intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.fSize == 0L;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStartTimesIndex.containsValue(o);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStartTimesIndex.values().containsAll(c);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.fLock.readLock().lock();
        try {
            Object[] objectArray = this.fStartTimesIndex.values().toArray();
            return objectArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fLock.readLock().lock();
        try {
            T[] TArray = this.fStartTimesIndex.values().toArray(a);
            return TArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.fLock.writeLock().lock();
        try {
            this.fSize = 0L;
            this.fEndTimesIndex.clear();
            this.fStartTimesIndex.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.readLock().lock();
        try {
            Iterable matchStarts = Iterables.concat(this.fStartTimesIndex.asMap().headMap(end, true).values());
            Iterable matchEnds = Iterables.concat(this.fEndTimesIndex.asMap().tailMap(start, true).values());
            Iterable iterable = (Iterable)NonNullUtils.checkNotNull((Object)Sets.intersection((Set)Sets.newHashSet((Iterable)matchStarts), (Set)Sets.newHashSet((Iterable)matchEnds)));
            return iterable;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.fLock.writeLock().lock();
        try {
            this.fStartTimesIndex.clear();
            this.fEndTimesIndex.clear();
            this.fSize = 0L;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }
}

