/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystemPushPopTest {
    private ITmfStateSystemBuilder ss;
    private int attribute;
    private File testHtFile;
    private static final String errMsg = "Caught exception: ";
    private static final ITmfStateValue value1 = TmfStateValue.newValueString((String)"A");
    private static final ITmfStateValue value2 = TmfStateValue.newValueInt((int)10);
    private static final ITmfStateValue value3 = TmfStateValue.nullValue();
    private static final ITmfStateValue value4 = TmfStateValue.newValueString((String)"D");
    private static final ITmfStateValue value5 = TmfStateValue.newValueLong((long)Long.MAX_VALUE);

    @Before
    public void setUp() throws IOException, TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.testHtFile = File.createTempFile("test", ".ht");
        IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)"push-pop-test", (File)((File)NonNullUtils.checkNotNull((Object)this.testHtFile)), (int)0, (long)0L, (int)0);
        this.ss = new StateSystem(backend, true);
        int attrib = this.ss.getQuarkAbsoluteAndAdd(new String[]{"Test", "stack"});
        this.ss.pushAttribute(2L, value1, attrib);
        this.ss.pushAttribute(4L, value2, attrib);
        this.ss.pushAttribute(6L, value3, attrib);
        this.ss.pushAttribute(8L, value4, attrib);
        this.ss.pushAttribute(10L, value5, attrib);
        ITmfStateValue value = this.ss.popAttribute(11L, attrib);
        Assert.assertEquals((Object)value5, (Object)value);
        value = this.ss.popAttribute(12L, attrib);
        Assert.assertEquals((Object)value4, (Object)value);
        value = this.ss.popAttribute(14L, attrib);
        Assert.assertEquals((Object)value3, (Object)value);
        value = this.ss.popAttribute(16L, attrib);
        Assert.assertEquals((Object)value2, (Object)value);
        value = this.ss.popAttribute(17L, attrib);
        Assert.assertEquals((Object)value1, (Object)value);
        value = this.ss.popAttribute(20L, attrib);
        Assert.assertEquals(null, (Object)value);
        this.ss.pushAttribute(21L, value1, attrib);
        this.ss.pushAttribute(22L, value2, attrib);
        value = this.ss.popAttribute(24L, attrib);
        Assert.assertEquals((Object)value2, (Object)value);
        value = this.ss.popAttribute(26L, attrib);
        Assert.assertEquals((Object)value1, (Object)value);
        value = this.ss.popAttribute(28L, attrib);
        Assert.assertEquals(null, (Object)value);
        this.ss.closeHistory(30L);
        this.attribute = this.ss.getQuarkAbsolute(new String[]{"Test", "stack"});
    }

    @After
    public void tearDown() {
        this.testHtFile.delete();
    }

    @Test
    public void testBeginEnd() {
        try {
            ITmfStateInterval interval = this.ss.querySingleState(0L, this.attribute);
            Assert.assertEquals((long)0L, (long)interval.getStartTime());
            Assert.assertEquals((long)1L, (long)interval.getEndTime());
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
            interval = this.ss.querySingleState(29L, this.attribute);
            Assert.assertEquals((long)26L, (long)interval.getStartTime());
            Assert.assertEquals((long)30L, (long)interval.getEndTime());
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)(errMsg + e.toString()));
        }
    }

    @Test
    public void testSingleQueries() {
        try {
            int subAttribute1 = this.ss.getQuarkRelative(this.attribute, new String[]{"1"});
            int subAttribute2 = this.ss.getQuarkRelative(this.attribute, new String[]{"2"});
            ITmfStateInterval interval = this.ss.querySingleState(11L, this.attribute);
            Assert.assertEquals((long)4L, (long)interval.getStateValue().unboxInt());
            interval = this.ss.querySingleState(24L, this.attribute);
            Assert.assertEquals((long)1L, (long)interval.getStateValue().unboxInt());
            interval = this.ss.querySingleState(10L, subAttribute1);
            Assert.assertEquals((Object)value1, (Object)interval.getStateValue());
            interval = this.ss.querySingleState(22L, subAttribute2);
            Assert.assertEquals((Object)value2, (Object)interval.getStateValue());
            interval = this.ss.querySingleState(25L, subAttribute2);
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)(errMsg + e.toString()));
        }
    }

    @Test
    public void testStackTop() {
        ITmfStateSystemBuilder ss2 = this.ss;
        Assert.assertNotNull((Object)ss2);
        try {
            ITmfStateInterval interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)10L, (int)this.attribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)value5, (Object)interval.getStateValue());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)9L, (int)this.attribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)value4, (Object)interval.getStateValue());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)13L, (int)this.attribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)value3, (Object)interval.getStateValue());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)16L, (int)this.attribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)value1, (Object)interval.getStateValue());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)25L, (int)this.attribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)value1, (Object)interval.getStateValue());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)(errMsg + e.toString()));
        }
    }

    @Test
    public void testEmptyStack() {
        ITmfStateSystemBuilder ss2 = this.ss;
        Assert.assertNotNull((Object)ss2);
        try {
            ITmfStateInterval interval = this.ss.querySingleState(1L, this.attribute);
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)1L, (int)this.attribute);
            Assert.assertEquals(null, (Object)interval);
            interval = this.ss.querySingleState(19L, this.attribute);
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)19L, (int)this.attribute);
            Assert.assertEquals(null, (Object)interval);
            interval = this.ss.querySingleState(27L, this.attribute);
            Assert.assertTrue((boolean)interval.getStateValue().isNull());
            interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss2, (long)27L, (int)this.attribute);
            Assert.assertEquals(null, (Object)interval);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)(errMsg + e.toString()));
        }
    }

    @Test
    public void testFullQueries() {
        try {
            int subAttrib1 = this.ss.getQuarkRelative(this.attribute, new String[]{"1"});
            int subAttrib2 = this.ss.getQuarkRelative(this.attribute, new String[]{"2"});
            int subAttrib3 = this.ss.getQuarkRelative(this.attribute, new String[]{"3"});
            int subAttrib4 = this.ss.getQuarkRelative(this.attribute, new String[]{"4"});
            List state = this.ss.queryFullState(10L);
            Assert.assertEquals((long)5L, (long)((ITmfStateInterval)state.get(this.attribute)).getStateValue().unboxInt());
            Assert.assertEquals((Object)value1, (Object)((ITmfStateInterval)state.get(subAttrib1)).getStateValue());
            Assert.assertEquals((Object)value2, (Object)((ITmfStateInterval)state.get(subAttrib2)).getStateValue());
            Assert.assertEquals((Object)value3, (Object)((ITmfStateInterval)state.get(subAttrib3)).getStateValue());
            Assert.assertEquals((Object)value4, (Object)((ITmfStateInterval)state.get(subAttrib4)).getStateValue());
            state = this.ss.queryFullState(18L);
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(this.attribute)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib1)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib2)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib3)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib4)).getStateValue().isNull());
            state = this.ss.queryFullState(21L);
            Assert.assertEquals((long)1L, (long)((ITmfStateInterval)state.get(this.attribute)).getStateValue().unboxInt());
            Assert.assertEquals((Object)value1, (Object)((ITmfStateInterval)state.get(subAttrib1)).getStateValue());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib2)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib3)).getStateValue().isNull());
            Assert.assertTrue((boolean)((ITmfStateInterval)state.get(subAttrib4)).getStateValue().isNull());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)(errMsg + e.toString()));
        }
    }
}

