/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.statevalue;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.SafeByteBufferFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.statevalue.StateValueTestBase;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.statevalues.CustomStateValueStub;
import org.junit.Assert;
import org.junit.Test;

public class CustomStateValueTest
extends StateValueTestBase {
    private static final CustomStateValue VALUE = new CustomStateValueStub(3, "MyString");

    @Override
    protected @NonNull ITmfStateValue getStateValueFixture() {
        return VALUE;
    }

    @Override
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ITmfStateValue.Type getStateValueType() {
        return ITmfStateValue.Type.CUSTOM;
    }

    @Test
    public void testSerialization() {
        CustomStateValueStub.registerFactory();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ISafeByteBufferWriter safeBufferWriter = SafeByteBufferFactory.wrapWriter((ByteBuffer)buffer, (int)VALUE.getSerializedSize());
        VALUE.serialize(safeBufferWriter);
        buffer.flip();
        ISafeByteBufferReader safeBufferReader = SafeByteBufferFactory.wrapReader((ByteBuffer)buffer, (int)VALUE.getSerializedSize());
        TmfStateValue read = CustomStateValue.readSerializedValue((ISafeByteBufferReader)safeBufferReader);
        Assert.assertEquals((String)"Custom state value: no factory", (Object)VALUE, (Object)read);
    }

    @Test
    public void testNoFactoryAvailable() {
        CustomStateValueStub.unregisterFactory();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ISafeByteBufferWriter safeBufferWriter = SafeByteBufferFactory.wrapWriter((ByteBuffer)buffer, (int)VALUE.getSerializedSize());
        VALUE.serialize(safeBufferWriter);
        buffer.flip();
        ISafeByteBufferReader safeBufferReader = SafeByteBufferFactory.wrapReader((ByteBuffer)buffer, (int)VALUE.getSerializedSize());
        TmfStateValue read = CustomStateValue.readSerializedValue((ISafeByteBufferReader)safeBufferReader);
        Assert.assertEquals((String)"Custom state value: no factory", (Object)TmfStateValue.nullValue(), (Object)read);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testSerializedTooLarge() {
        String alphabet = "abcdefghijklmnopqrstuvwxyz";
        StringBuilder builder = new StringBuilder();
        while (builder.length() < Short.MAX_VALUE) {
            builder.append(alphabet);
        }
        CustomStateValueStub sv = new CustomStateValueStub(3, builder.toString());
        sv.getSerializedSize();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongCustomId() {
        CustomStateValue.registerCustomFactory((byte)0, (CustomStateValue.CustomStateValueFactory)CustomStateValueStub.FACTORY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongCustomId2() {
        CustomStateValue.registerCustomFactory((byte)20, (CustomStateValue.CustomStateValueFactory)CustomStateValueStub.FACTORY);
    }
}

