/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public enum TmfXmlTestFiles {
    VALID_FILE("test_xml_files/test_valid/test_valid.xml"),
    INVALID_FILE("test_xml_files/test_invalid/test_invalid.xml"),
    ATTRIBUTE_FILE("test_xml_files/test_valid/test_attributes.xml"),
    STATE_VALUE_FILE("test_xml_files/test_valid/test_state_values.xml"),
    CONDITION_FILE("test_xml_files/test_valid/test_conditions.xml"),
    DOUBLES_FILE("test_xml_files/test_valid/test_doubles.xml"),
    VALID_PATTERN_FILE("test_xml_files/test_valid/test_valid_pattern.xml"),
    VALID_PATTERN_SEGMENT("test_xml_files/test_valid/test_pattern_segment.xml"),
    CONSUMING_FSM_TEST("test_xml_files/test_valid/test_consuming_fsm.xml"),
    INITIAL_STATE_ELEMENT_TEST_FILE_1("test_xml_files/test_valid/test_initialState_element1.xml"),
    INITIAL_STATE_ELEMENT_TEST_FILE_2("test_xml_files/test_valid/test_initialState_element2.xml");

    private final String fPath;

    private TmfXmlTestFiles(String file) {
        this.fPath = file;
    }

    public IPath getPath() {
        IPath absPath = Activator.getAbsolutePath(new Path(this.fPath));
        if (absPath == null) {
            Assert.fail((String)("Cannot find file path for '" + this.fPath + "'"));
        }
        return absPath;
    }

    public File getFile() {
        return this.getPath().toFile();
    }

    public Document getXmlDocument() {
        Document doc = null;
        try {
            doc = XmlUtils.getDocumentFromFile((File)this.getFile());
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)"Xml document parse exception");
        }
        catch (SAXException e) {
            Assert.fail((String)"Exception parsing xml file");
        }
        catch (IOException e) {
            Assert.fail((String)"File io exception");
        }
        return doc;
    }
}

