/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtilsTest {
    private static final Path PATH_INVALID = new Path("test_xml_files/test_invalid");
    private static final Path PATH_VALID = new Path("test_xml_files/test_valid");
    private static final @NonNull String ANALYSIS_ID = "kernel.linux.sp";

    @After
    public void emptyXmlFolder() {
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
    }

    @Test
    public void testXmlPath() {
        IPath xmlPath = XmlUtils.getXmlFilesPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath workspacePath = workspace.getRoot().getRawLocation();
        workspacePath = workspacePath.addTrailingSeparator().append(".metadata").addTrailingSeparator().append(".plugins").addTrailingSeparator().append("org.eclipse.tracecompass.tmf.analysis.xml.core").addTrailingSeparator().append("xml_files");
        Assert.assertEquals((Object)xmlPath, (Object)workspacePath);
    }

    @Test
    public void testXmlValidate() {
        IStatus status;
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (!(status = XmlUtils.xmlValidate((File)testXmlFile)).isOK()) {
            Assert.fail((String)status.getMessage());
        }
        if ((testXmlFile = TmfXmlTestFiles.INVALID_FILE.getFile()) == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        Assert.assertFalse((boolean)XmlUtils.xmlValidate((File)testXmlFile).isOK());
    }

    @Test
    public void testXmlValidateInvalid() {
        IPath path = Activator.getAbsolutePath(PATH_INVALID);
        File file = path.toFile();
        File[] invalidFiles = file.listFiles();
        Assert.assertTrue((invalidFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = invalidFiles;
        int n = invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertFalse((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlValidateValid() {
        IPath path = Activator.getAbsolutePath(PATH_VALID);
        File file = path.toFile();
        File[] validFiles = file.listFiles();
        Assert.assertTrue((validFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = validFiles;
        int n = validFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertTrue((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlAddFile() {
        IPath xmlPath = XmlUtils.getXmlFilesPath().addTrailingSeparator().append("test_valid.xml");
        File destFile = xmlPath.toFile();
        Assert.assertFalse((boolean)destFile.exists());
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        Assert.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testGetElementInFile() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        Assert.assertNotNull((String)"XML test file does not exist", (Object)testXmlFile);
        Assert.assertTrue((String)"XML test file does not exist", (boolean)testXmlFile.exists());
        Element analysis = XmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        Assert.assertNotNull((Object)analysis);
    }

    @Test
    public void testGetChildElements() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (testXmlFile == null) {
            return;
        }
        Element analysis = XmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        List values = XmlUtils.getChildElements((Element)analysis, (String)"location");
        Assert.assertEquals((long)5L, (long)values.size());
        Element aLocation = (Element)values.get(0);
        List attributes = XmlUtils.getChildElements((Element)aLocation, (String)"stateAttribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        values = XmlUtils.getChildElements((Element)analysis, (String)"head");
        Assert.assertEquals((long)1L, (long)values.size());
        Element head = (Element)values.get(0);
        values = XmlUtils.getChildElements((Element)head);
        Assert.assertEquals((long)2L, (long)values.size());
    }

    public static @NonNull ITmfTrace initializeTrace(String traceFile) {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        try {
            trace.initTrace(null, Activator.getAbsolutePath(new Path(traceFile)).toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e1) {
            Assert.fail((String)e1.getMessage());
        }
        return trace;
    }

    public static @NonNull XmlStateSystemModule initializeModule(TmfXmlTestFiles xmlAnalysisFile) {
        Document doc = xmlAnalysisFile.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
        Assert.assertFalse((stateproviderNodes.getLength() == 0 ? 1 : 0) != 0);
        Element node = (Element)stateproviderNodes.item(0);
        XmlStateSystemModule module = new XmlStateSystemModule();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        module.setId(moduleId);
        module.setXmlFile(xmlAnalysisFile.getPath());
        return module;
    }

    public static @NonNull XmlPatternAnalysis initializePatternModule(TmfXmlTestFiles xmlAnalysisFile) {
        Document doc = xmlAnalysisFile.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList patternNodes = doc.getElementsByTagName("pattern");
        Assert.assertFalse((patternNodes.getLength() == 0 ? 1 : 0) != 0);
        Element node = (Element)patternNodes.item(0);
        XmlPatternAnalysis analysis = new XmlPatternAnalysis();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        analysis.setId(moduleId);
        analysis.setXmlFile(xmlAnalysisFile.getPath());
        return analysis;
    }

    public static void verifyStateIntervals(String testId, @NonNull ITmfStateSystem ss, Integer quark, int[] expectedStarts, ITmfStateValue[] expectedValues) throws AttributeNotFoundException, StateSystemDisposedException {
        int expectedCount = expectedStarts.length - 1;
        List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)expectedStarts[0], (long)expectedStarts[expectedCount]);
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)interval.getStateValue());
            ++i;
        }
    }

    public static void verifyStackStateIntervals(String testId, @NonNull ITmfStateSystem ss, Integer quark, int[] expectedStarts, ITmfStateValue[] expectedValues) throws AttributeNotFoundException, StateSystemDisposedException {
        int expectedCount = expectedStarts.length - 1;
        List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)expectedStarts[0], (long)expectedStarts[expectedCount]);
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            @Nullable ITmfStateInterval stackValueInterval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)interval.getStartTime(), (int)quark);
            Assert.assertNotNull((Object)stackValueInterval);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)stackValueInterval.getStateValue());
            ++i;
        }
    }

    public static void testPatternSegmentData(TmfXmlPatternSegment expected, TmfXmlPatternSegment actual) {
        Assert.assertEquals((String)"getStart", (long)expected.getStart(), (long)actual.getStart());
        Assert.assertEquals((String)"getEnd", (long)expected.getEnd(), (long)actual.getEnd());
        Assert.assertEquals((String)"getScale", (long)expected.getScale(), (long)actual.getScale());
        Assert.assertEquals((String)"getName", (Object)expected.getName(), (Object)actual.getName());
        Assert.assertNotNull((String)"getContent", (Object)actual.getContent());
        Assert.assertEquals((String)"content size", (long)expected.getContent().size(), (long)actual.getContent().size());
        Iterator<Map.Entry<K, @NonNull V>> it2 = expected.getContent().entrySet().iterator();
        int i = 0;
        while (i < expected.getContent().size()) {
            Map.Entry<K, @NonNull V> expectedContent = it2.next();
            ITmfStateValue actualValue = (ITmfStateValue)actual.getContent().get(expectedContent.getKey());
            Assert.assertNotNull((String)("Content " + (String)expectedContent.getKey() + " exists"), (Object)actualValue);
            Assert.assertEquals((String)("Content value comparison " + i), (long)0L, (long)((ITmfStateValue)expectedContent.getValue()).compareTo((Object)actualValue));
            ++i;
        }
    }
}

