/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlPatternSegmentBuilder {
    public static final String UNKNOWN_STRING = "unknown";
    public static final String PATTERN_SEGMENT_NAME_PREFIX = "seg_";
    private final ITmfXmlModelFactory fModelFactory;
    private final IXmlStateSystemContainer fContainer;
    private final List<TmfXmlPatternSegmentField> fFields = new ArrayList<TmfXmlPatternSegmentField>();
    private final TmfXmlPatternSegmentType fSegmentType;

    public TmfXmlPatternSegmentBuilder(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        this.fModelFactory = modelFactory;
        this.fContainer = parent;
        NodeList nodesSegmentType = node.getElementsByTagName("segType");
        Element element = (Element)nodesSegmentType.item(0);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.fSegmentType = new TmfXmlPatternSegmentType(element);
        NodeList nodesSegmentContent = node.getElementsByTagName("segContent");
        Element fContentElement = (Element)nodesSegmentContent.item(0);
        if (fContentElement != null) {
            NodeList nodesSegmentField = fContentElement.getElementsByTagName("segField");
            int i = 0;
            while (i < nodesSegmentField.getLength()) {
                this.fFields.add(new TmfXmlPatternSegmentField((Element)NonNullUtils.checkNotNull((Object)((Element)nodesSegmentField.item(i)))));
                ++i;
            }
        }
    }

    public TmfXmlPatternSegment generatePatternSegment(ITmfEvent event, ITmfTimestamp start, ITmfTimestamp end, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        int scale = event.getTimestamp().getScale();
        long startValue = start.toNanos();
        long endValue = end.toNanos();
        String segmentName = this.getPatternSegmentName(event, scenarioInfo);
        HashMap<String, ITmfStateValue> fields = new HashMap<String, ITmfStateValue>();
        this.setPatternSegmentContent(event, fields, scenarioInfo);
        TmfXmlPatternSegment segment = new TmfXmlPatternSegment(startValue, endValue, scale, segmentName, fields);
        if (this.fContainer instanceof XmlPatternStateProvider) {
            ((XmlPatternStateProvider)this.fContainer).getListener().onNewSegment(segment);
        }
        return segment;
    }

    private String getPatternSegmentName(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        return this.fSegmentType.getName(event, scenarioInfo);
    }

    private void setPatternSegmentContent(ITmfEvent event, Map<String, ITmfStateValue> fields, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        for (TmfXmlPatternSegmentField field : this.fFields) {
            fields.put(field.getName().intern(), field.getValue(event, scenarioInfo));
        }
        if (scenarioInfo != null) {
            this.addStoredFieldsContent(event, fields, scenarioInfo);
        }
    }

    protected void addStoredFieldsContent(ITmfEvent event, Map<String, ITmfStateValue> fields, TmfXmlScenarioInfo info) {
        if (this.fContainer instanceof XmlPatternStateProvider) {
            for (Map.Entry<String, String> entry : ((XmlPatternStateProvider)this.fContainer).getStoredFields().entrySet()) {
                ITmfStateValue value = ((XmlPatternStateProvider)this.fContainer).getHistoryBuilder().getStoredFieldValue(this.fContainer, entry.getValue(), info, event);
                if (value.isNull()) continue;
                fields.put(entry.getValue().intern(), value);
            }
        }
    }

    private static ITmfStateValue getStateValueFromConstant(String constantValue, String type) {
        switch (type) {
            case "int": {
                return TmfStateValue.newValueInt((int)Integer.parseInt(constantValue));
            }
            case "long": {
                return TmfStateValue.newValueLong((long)Long.parseLong(constantValue));
            }
            case "string": {
                return TmfStateValue.newValueString((String)constantValue);
            }
            case "null": {
                return TmfStateValue.nullValue();
            }
        }
        throw new IllegalArgumentException("Invalid type of field : " + type);
    }

    private static void getNameFromXmlStateValue(ITmfEvent event, StringBuilder builder, ITmfXmlStateValue xmlStateValue, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        try {
            ITmfStateValue value = xmlStateValue.getValue(event, scenarioInfo);
            switch (value.getType()) {
                case DOUBLE: {
                    builder.append(value.unboxDouble());
                    break;
                }
                case INTEGER: {
                    builder.append(value.unboxInt());
                    break;
                }
                case LONG: {
                    builder.append(value.unboxLong());
                    break;
                }
                case NULL: {
                    builder.append(UNKNOWN_STRING);
                    break;
                }
                case STRING: {
                    builder.append(value.unboxStr());
                    break;
                }
                default: {
                    throw new StateValueTypeException("Invalid type of state value");
                }
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.logInfo("Impossible to get the state value", e);
        }
    }

    private class TmfXmlPatternSegmentField {
        private final String fName;
        private final String fType;
        private final @Nullable ITmfStateValue fStateValue;
        private final @Nullable ITmfXmlStateValue fXmlStateValue;

        public TmfXmlPatternSegmentField(Element element) {
            this.fName = element.getAttribute("name");
            this.fType = element.getAttribute("type");
            String constantValue = element.getAttribute("value");
            if (constantValue.isEmpty() && !this.fType.equals("null")) {
                this.fStateValue = null;
                Element elementFieldStateValue = (Element)element.getElementsByTagName("stateValue").item(0);
                if (elementFieldStateValue == null) {
                    throw new IllegalArgumentException("The value of the field " + this.fName + " is missing");
                }
                this.fXmlStateValue = TmfXmlPatternSegmentBuilder.this.fModelFactory.createStateValue(elementFieldStateValue, TmfXmlPatternSegmentBuilder.this.fContainer, new ArrayList<ITmfXmlStateAttribute>());
            } else {
                this.fStateValue = TmfXmlPatternSegmentBuilder.getStateValueFromConstant(constantValue, this.fType);
                this.fXmlStateValue = null;
            }
        }

        public ITmfStateValue getValue(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            if (this.fStateValue != null) {
                return this.fStateValue;
            }
            try {
                return ((ITmfXmlStateValue)NonNullUtils.checkNotNull((Object)this.fXmlStateValue)).getValue(event, scenarioInfo);
            }
            catch (AttributeNotFoundException e) {
                Activator.logError("Failed to get the state value", e);
                throw new IllegalStateException("Failed to get the value for the segment field " + this.fName);
            }
        }

        public String getName() {
            return this.fName;
        }
    }

    private class TmfXmlPatternSegmentType {
        private final String fSegmentNameAttribute;
        private final @Nullable ITmfXmlStateValue fNameStateValue;

        public TmfXmlPatternSegmentType(Element element) {
            this.fSegmentNameAttribute = element.getAttribute("segName");
            if (!this.fSegmentNameAttribute.isEmpty()) {
                this.fNameStateValue = null;
            } else {
                Element elementSegmentNameStateValue = (Element)element.getElementsByTagName("stateValue").item(0);
                if (elementSegmentNameStateValue == null) {
                    throw new IllegalArgumentException("Failed to get the segment name. A state value is needed.");
                }
                this.fNameStateValue = TmfXmlPatternSegmentBuilder.this.fModelFactory.createStateValue(elementSegmentNameStateValue, TmfXmlPatternSegmentBuilder.this.fContainer, new ArrayList<ITmfXmlStateAttribute>());
            }
        }

        public String getName(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            StringBuilder name = new StringBuilder(TmfXmlPatternSegmentBuilder.PATTERN_SEGMENT_NAME_PREFIX);
            if (this.fNameStateValue != null) {
                TmfXmlPatternSegmentBuilder.getNameFromXmlStateValue(event, name, this.fNameStateValue, scenarioInfo);
            } else {
                name.append(this.fSegmentNameAttribute);
            }
            return name.toString().intern();
        }
    }
}

