/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.tests.module;

import java.util.Iterator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.Assert;
import org.junit.Test;

public class XmlAnalysisOutputSourceTest {
    private static final String BUILTIN_MODULE = "test.builtin.sp";
    private static final String BUILTIN_OUTPUT = "Test output of XML builtin module";

    @Test
    public void testBuiltinOutput() {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        try {
            trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
            IAnalysisModule module = trace.getAnalysisModule(BUILTIN_MODULE);
            Assert.assertNotNull((Object)module);
            Iterator iterator = module.getOutputs().iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            IAnalysisOutput output = (IAnalysisOutput)iterator.next();
            Assert.assertEquals((Object)BUILTIN_OUTPUT, (Object)output.getName());
        }
        finally {
            trace.dispose();
        }
    }
}

