/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlLatencyViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternDensityViewer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternLatencyTableViewer;

public class PatternDensityView
extends AbstractSegmentStoreDensityView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.density";
    private final XmlLatencyViewInfo fViewInfo = new XmlLatencyViewInfo("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.density");
    private PatternDensityViewer fDensityViewer;
    private PatternLatencyTableViewer fTableViewer;

    public PatternDensityView() {
        super(ID);
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue;
                if (event.getProperty().equals("xmlLatencyOutputData") && (newValue = event.getNewValue()) instanceof String) {
                    String data = (String)newValue;
                    PatternDensityView.this.fViewInfo.setViewData(data);
                    PatternDensityView.this.loadTableViewer();
                    PatternDensityView.this.loadDensityViewer();
                }
            }
        });
    }

    private void loadTableViewer() {
        if (this.fTableViewer != null) {
            this.fTableViewer.updateViewer(this.fViewInfo.getViewAnalysisId());
        }
    }

    private void loadDensityViewer() {
        if (this.fDensityViewer != null) {
            this.fDensityViewer.updateViewer(this.fViewInfo.getViewAnalysisId());
        }
    }

    protected @NonNull AbstractSegmentStoreTableViewer createSegmentStoreTableViewer(@NonNull Composite parent) {
        PatternLatencyTableViewer tableViewer;
        this.fTableViewer = tableViewer = new PatternLatencyTableViewer(new TableViewer(parent, 0x10010000)){

            protected void createProviderColumns() {
                super.createProviderColumns();
                Table t = (Table)this.getControl();
                int[] nArray = new int[5];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                t.setColumnOrder(nArray);
            }
        };
        this.loadTableViewer();
        return tableViewer;
    }

    protected @NonNull AbstractSegmentStoreDensityViewer createSegmentStoreDensityViewer(@NonNull Composite parent) {
        PatternDensityViewer densityViewer;
        this.fDensityViewer = densityViewer = new PatternDensityViewer((Composite)NonNullUtils.checkNotNull((Object)parent));
        this.loadDensityViewer();
        return densityViewer;
    }
}

