/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCustomTraceDataTest {
    protected static final String TIMESTAMP_FORMAT = "dd/MM/yyyy HH:mm:ss:SSS";
    protected static final int BLOCK_SIZE = 100;
    protected static final String TRACE_DIRECTORY = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "dummyTrace";
    private final @NonNull ICustomTestData fTestData;
    private ITmfTrace fTrace;

    public AbstractCustomTraceDataTest(@NonNull ICustomTestData data) {
        this.fTestData = data;
    }

    @Before
    public void setUp() throws Exception {
        this.setupTrace();
    }

    private synchronized void setupTrace() throws Exception {
        File traceDirectory = new File(TRACE_DIRECTORY);
        if (traceDirectory.exists()) {
            traceDirectory.delete();
        }
        traceDirectory.mkdir();
        if (this.fTrace == null) {
            this.fTrace = this.fTestData.getTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    @After
    public void tearDown() {
        block5: {
            directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this.fTrace);
            try {
                this.fTrace.dispose();
                this.fTrace = null;
            }
            finally {
                dir = new File(directory);
                if (!dir.exists()) break block5;
                var8_8 = files = dir.listFiles();
                var7_10 = files.length;
                var6_12 = 0;
                ** while (var6_12 < var7_10)
            }
lbl-1000:
            // 1 sources

            {
                file = var8_8[var6_12];
                file.delete();
                ++var6_12;
                continue;
            }
lbl18:
            // 1 sources

            dir.delete();
        }
        trace = new File(AbstractCustomTraceDataTest.TRACE_DIRECTORY);
        if (trace.exists()) {
            trace.delete();
        }
    }

    @Test
    public void testReadingEvents() {
        ITmfTrace trace = this.fTrace;
        ITmfContext ctx = trace.seekEvent(0L);
        int eventCount = 0;
        ITmfEvent event = trace.getNext(ctx);
        while (event != null) {
            this.fTestData.validateEvent(event);
            ++eventCount;
            event = trace.getNext(ctx);
        }
        this.fTestData.validateEventCount(eventCount);
    }

    protected static interface ICustomTestData {
        public ITmfTrace getTrace() throws IOException, TmfTraceException;

        public void validateEvent(ITmfEvent var1);

        public void validateEventCount(int var1);
    }
}

