/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class AttributePoolTest {
    private static final long START_TIME = 1000L;
    private static final String DUMMY_STRING = "test";
    private static final ITmfStateValue VALUE = TmfStateValue.newValueInt((int)2);
    private ITmfStateSystemBuilder fStateSystem;

    public AttributePoolTest() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1000L);
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
    }

    @After
    public void tearDown() {
        this.fStateSystem.dispose();
    }

    @Test
    public void testConstructorGood() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1));
        Assert.assertNotNull((Object)pool);
        int quark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
        pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(quark));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorBad() {
        new TmfAttributePool(this.fStateSystem, Integer.valueOf(-2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorBad2() {
        new TmfAttributePool(this.fStateSystem, Integer.valueOf(3));
    }

    @Test
    public void testSimplePool() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1));
        Assert.assertNotNull((Object)pool);
        Integer available = pool.getAvailable();
        Assert.assertNotNull((Object)available);
        Integer available2 = pool.getAvailable();
        Assert.assertNotNull((Object)available2);
        Assert.assertNotEquals((Object)available, (Object)available2);
        Assert.assertEquals((Object)"0", (Object)this.fStateSystem.getAttributeName(available.intValue()));
        Assert.assertEquals((Object)"1", (Object)this.fStateSystem.getAttributeName(available2.intValue()));
        this.fStateSystem.modifyAttribute(1010L, VALUE, available.intValue());
        this.fStateSystem.modifyAttribute(1010L, VALUE, available2.intValue());
        pool.recycle(available.intValue(), 1020L);
        ITmfStateValue value = this.fStateSystem.queryOngoingState(available.intValue());
        Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
        Integer available3 = pool.getAvailable();
        Assert.assertEquals((Object)available, (Object)available3);
        Integer available4 = pool.getAvailable();
        Assert.assertNotEquals((Object)available3, (Object)available4);
        Assert.assertNotEquals((Object)available2, (Object)available4);
        pool.recycle(available4.intValue(), 1030L);
        pool.recycle(available2.intValue(), 1030L);
        pool.recycle(available3.intValue(), 1030L);
        Integer available5 = pool.getAvailable();
        Assert.assertEquals((Object)available4, (Object)available5);
        Integer available6 = pool.getAvailable();
        Assert.assertEquals((Object)available2, (Object)available6);
        Integer available7 = pool.getAvailable();
        Assert.assertEquals((Object)available3, (Object)available7);
    }

    @Test
    public void testPoolWithSubTree() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1));
        Assert.assertNotNull((Object)pool);
        Integer available = pool.getAvailable();
        Assert.assertNotNull((Object)available);
        try {
            Integer child1 = this.fStateSystem.getQuarkRelativeAndAdd(available.intValue(), new String[]{"child1"});
            Integer child2 = this.fStateSystem.getQuarkRelativeAndAdd(available.intValue(), new String[]{"child2"});
            this.fStateSystem.modifyAttribute(1010L, VALUE, available.intValue());
            this.fStateSystem.modifyAttribute(1010L, VALUE, child1.intValue());
            this.fStateSystem.modifyAttribute(1010L, VALUE, child2.intValue());
            pool.recycle(available.intValue(), 1020L);
            ITmfStateValue value = this.fStateSystem.queryOngoingState(available.intValue());
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
            value = this.fStateSystem.queryOngoingState(child1.intValue());
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
            value = this.fStateSystem.queryOngoingState(child2.intValue());
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPriorityPool() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1), TmfAttributePool.QueueType.PRIORITY);
        Assert.assertNotNull((Object)pool);
        Integer available = pool.getAvailable();
        Assert.assertNotNull((Object)available);
        Integer available2 = pool.getAvailable();
        Assert.assertNotNull((Object)available2);
        Assert.assertNotEquals((Object)available, (Object)available2);
        Assert.assertEquals((Object)"0", (Object)this.fStateSystem.getAttributeName(available.intValue()));
        Assert.assertEquals((Object)"1", (Object)this.fStateSystem.getAttributeName(available2.intValue()));
        pool.recycle(available.intValue(), 1020L);
        Integer available3 = pool.getAvailable();
        Assert.assertEquals((Object)available, (Object)available3);
        Integer available4 = pool.getAvailable();
        Assert.assertNotEquals((Object)available3, (Object)available4);
        Assert.assertNotEquals((Object)available2, (Object)available4);
        pool.recycle(available4.intValue(), 1030L);
        pool.recycle(available2.intValue(), 1030L);
        pool.recycle(available3.intValue(), 1030L);
        Integer available5 = pool.getAvailable();
        Assert.assertEquals((Object)available3, (Object)available5);
        Integer available6 = pool.getAvailable();
        Assert.assertEquals((Object)available2, (Object)available6);
        Integer available7 = pool.getAvailable();
        Assert.assertEquals((Object)available4, (Object)available7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRecycleWrongQuark() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1));
        Assert.assertNotNull((Object)pool);
        pool.recycle(-1, 1010L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRecycleChildQuark() {
        TmfAttributePool pool = new TmfAttributePool(this.fStateSystem, Integer.valueOf(-1));
        Assert.assertNotNull((Object)pool);
        Integer available = pool.getAvailable();
        Assert.assertNotNull((Object)available);
        try {
            Integer child1 = this.fStateSystem.getQuarkRelativeAndAdd(available.intValue(), new String[]{"child1"});
            pool.recycle(child1.intValue(), 1010L);
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

