/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.osgi.framework.Bundle;

public class TmfTraceTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static final long DEFAULT_INITIAL_OFFSET_VALUE = 100000000L;
    private static final int NB_EVENTS = 10000;
    private TmfTraceStub fTrace = null;
    private static int SCALE = -3;

    @Before
    public void setUp() {
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            this.fTrace = new TmfTraceStub(test.toURI().getPath(), 1000, false, null);
            TmfSignalManager.deregister((Object)((Object)this.fTrace));
            this.fTrace.indexTrace(true);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fTrace = null;
        Assert.assertEquals((long)0L, (long)TmfProviderManager.getProviders(ITmfEvent.class).length);
    }

    @Test
    public void testFullConstructor() throws TmfTraceException {
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub trace = new TmfTraceStub(testfile.toURI().getPath(), 1000, false, null);
            trace.indexTrace(true);
            Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
            Assert.assertNull((String)"getResource", (Object)trace.getResource());
            Assert.assertEquals((String)"getPath", (Object)testfile.toURI().getPath(), (Object)trace.getPath());
            Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
            Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
            Assert.assertEquals((String)"getName", (Object)TEST_TRACE.getPath(), (Object)trace.getName());
            Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
            Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
            Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
            Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
            Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
            trace.dispose();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)"URISyntaxException");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException");
        }
    }

    @Test
    public void testLiveTraceConstructor() throws TmfTraceException {
        long interval = 100L;
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub trace = new TmfTraceStub(testfile.toURI().getPath(), 1000, 100L);
            trace.indexTrace(true);
            Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
            Assert.assertNull((String)"getResource", (Object)trace.getResource());
            Assert.assertEquals((String)"getPath", (Object)testfile.toURI().getPath(), (Object)trace.getPath());
            Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
            Assert.assertEquals((String)"getStreamingInterval", (long)100L, (long)trace.getStreamingInterval());
            Assert.assertEquals((String)"getName", (Object)TEST_TRACE.getPath(), (Object)trace.getName());
            Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
            Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
            Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
            Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
            Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
            trace.dispose();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)"URISyntaxException");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException");
        }
    }

    @Test
    public void testCopyConstructor() throws TmfTraceException {
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub original = new TmfTraceStub(testfile.toURI().getPath(), 1000, false, null);
            TmfTraceStub trace = new TmfTraceStub(original);
            trace.indexTrace(true);
            Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
            Assert.assertNull((String)"getResource", (Object)trace.getResource());
            Assert.assertEquals((String)"getPath", (Object)testfile.toURI().getPath(), (Object)trace.getPath());
            Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
            Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
            Assert.assertEquals((String)"getName", (Object)TEST_TRACE.getPath(), (Object)trace.getName());
            Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
            Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
            Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
            Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
            Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
            original.dispose();
            trace.dispose();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)"URISyntaxException");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException");
        }
        try {
            new TmfTraceStub(null);
            Assert.fail((String)"Missing exception");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testInitializeNullPath() {
        TmfTraceStub trace = new TmfTraceStub();
        try {
            trace.initialize(null, null, ITmfEvent.class);
            Assert.fail((String)"TmfTrace.initialize() - no exception thrown");
        }
        catch (TmfTraceException tmfTraceException) {
        }
        catch (Exception e) {
            Assert.fail((String)"TmfTrace.initialize() - wrong exception thrown");
        }
    }

    @Test
    public void testInitializeSimplePath() {
        TmfTraceStub trace = new TmfTraceStub();
        String path = "TraceName";
        try {
            trace.initialize(null, path, ITmfEvent.class);
        }
        catch (Exception e) {
            Assert.fail((String)"TmfTrace.initialize() - Exception thrown");
        }
        Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
        Assert.assertNull((String)"getResource", (Object)trace.getResource());
        Assert.assertEquals((String)"getPath", (Object)path, (Object)trace.getPath());
        Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
        Assert.assertEquals((String)"getName", (Object)path, (Object)trace.getName());
        Assert.assertEquals((String)"getNbEvents", (long)0L, (long)trace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)Long.MIN_VALUE, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)Long.MIN_VALUE, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testInitializeNormalPath() {
        TmfTraceStub trace = new TmfTraceStub();
        String name = "TraceName";
        String path = "/my/trace/path/" + name;
        try {
            trace.initialize(null, path, ITmfEvent.class);
        }
        catch (Exception e) {
            Assert.fail((String)"TmfTrace.initialize() - Exception thrown");
        }
        Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
        Assert.assertNull((String)"getResource", (Object)trace.getResource());
        Assert.assertEquals((String)"getPath", (Object)path, (Object)trace.getPath());
        Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
        Assert.assertEquals((String)"getName", (Object)name, (Object)trace.getName());
        Assert.assertEquals((String)"getNbEvents", (long)0L, (long)trace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)Long.MIN_VALUE, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)Long.MIN_VALUE, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testInitTrace() throws URISyntaxException, IOException, TmfTraceException, InterruptedException {
        TmfTraceStub trace = new TmfTraceStub();
        Assert.assertNull((String)"getEventType", (Object)trace.getEventType());
        Assert.assertNull((String)"getResource", (Object)trace.getResource());
        Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
        Assert.assertEquals((String)"getName", (Object)"", (Object)trace.getName());
        Assert.assertEquals((String)"getNbEvents", (long)0L, (long)trace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)Long.MIN_VALUE, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)Long.MIN_VALUE, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)Long.MIN_VALUE, (long)trace.getEndTime().getValue());
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        Assert.assertTrue((String)"validate", (boolean)trace.validate(null, testfile.getPath()).isOK());
        trace.initTrace(null, testfile.toURI().getPath(), ITmfEvent.class);
        trace.indexTrace(true);
        int nbSecs = 0;
        while (trace.getNbEvents() < 10000L && nbSecs < 10) {
            Thread.sleep(1000L);
            ++nbSecs;
        }
        if (trace.getNbEvents() < 10000L) {
            Assert.fail((String)"indexing");
        }
        Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)trace.getEventType());
        Assert.assertNull((String)"getResource", (Object)trace.getResource());
        Assert.assertEquals((String)"getCacheSize", (long)1000L, (long)trace.getCacheSize());
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
        Assert.assertEquals((String)"getName", (Object)TEST_TRACE.getPath(), (Object)trace.getName());
        Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testSetStreamingInterval() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub(this.fTrace);
        long interval = 0L;
        Assert.assertEquals((String)"getStreamingInterval", (long)interval, (long)trace.getStreamingInterval());
        interval = 100L;
        trace.setStreamingInterval(interval);
        Assert.assertEquals((String)"getStreamingInterval", (long)interval, (long)trace.getStreamingInterval());
        interval = -1L;
        trace.setStreamingInterval(interval);
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)trace.getStreamingInterval());
        interval = 0L;
        trace.setStreamingInterval(interval);
        Assert.assertEquals((String)"getStreamingInterval", (long)interval, (long)trace.getStreamingInterval());
        trace.dispose();
    }

    @Test
    public void testSetTimeRange() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub(this.fTrace);
        trace.indexTrace(true);
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
        trace.setTimeRange(new TmfTimeRange(TmfTimestamp.fromSeconds((long)100L), TmfTimestamp.fromSeconds((long)200L)));
        Assert.assertEquals((String)"setTimeRange", (long)100L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"setTimeRange", (long)200L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"setTimeRange", (long)100L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"setTimeRange", (long)200L, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testSetStartTime() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub(this.fTrace);
        trace.indexTrace(true);
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
        trace.setStartTime(TmfTimestamp.fromSeconds((long)100L));
        Assert.assertEquals((String)"setStartTime", (long)100L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"setStartTime", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"setStartTime", (long)100L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"setStartTime", (long)10000L, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testSetEndTime() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub(this.fTrace);
        trace.indexTrace(true);
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)10000L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)10000L, (long)trace.getEndTime().getValue());
        trace.setEndTime(TmfTimestamp.fromSeconds((long)100L));
        Assert.assertEquals((String)"setEndTime", (long)1L, (long)trace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"setEndTime", (long)100L, (long)trace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"setEndTime", (long)1L, (long)trace.getStartTime().getValue());
        Assert.assertEquals((String)"setEndTime", (long)100L, (long)trace.getEndTime().getValue());
        trace.dispose();
    }

    @Test
    public void testSetNbEvents() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub(this.fTrace);
        trace.indexTrace(true);
        Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
        trace.setNbEvents(0L);
        Assert.assertEquals((String)"getNbEvents", (long)0L, (long)trace.getNbEvents());
        trace.setNbEvents(-1L);
        Assert.assertEquals((String)"getNbEvents", (long)0L, (long)trace.getNbEvents());
        trace.setNbEvents(10001L);
        Assert.assertEquals((String)"getNbEvents", (long)10001L, (long)trace.getNbEvents());
        trace.setNbEvents(10000L);
        Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)trace.getNbEvents());
        trace.dispose();
    }

    @Test
    public void testGetModules() {
        Iterable modules = this.fTrace.getAnalysisModules();
        Assert.assertFalse((boolean)modules.iterator().hasNext());
        this.fTrace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this.fTrace, null));
        modules = this.fTrace.getAnalysisModules();
        Assert.assertTrue((boolean)modules.iterator().hasNext());
        int count = 0;
        for (IAnalysisModule module : modules) {
            if (!(module instanceof TestAnalysis)) continue;
            ++count;
            IAnalysisModule otherModule = this.fTrace.getAnalysisModule(module.getId());
            Assert.assertNotNull((Object)otherModule);
            Assert.assertEquals((Object)otherModule, (Object)module);
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSeekEventOnCacheBoundary() {
        ITmfContext context = this.fTrace.seekEvent(0L);
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        context = this.fTrace.seekEvent(context.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        ITmfContext tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)1001L, (int)SCALE));
        context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)4001L, (int)SCALE));
        context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testSeekEventNotOnCacheBoundary() {
        ITmfContext tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)10L, (int)SCALE));
        TmfContext context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)1000L, (int)SCALE));
        context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)1002L, (int)SCALE));
        context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        tmpContext = this.fTrace.seekEvent(TmfTimestamp.create((long)4501L, (int)SCALE));
        context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOutOfScope() {
        ITmfContext tmpContext = this.fTrace.seekEvent(0L);
        TmfContext context = this.fTrace.seekEvent(tmpContext.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)10001L, (int)SCALE));
        Assert.assertNull((String)"Event timestamp", (Object)context.getLocation());
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext((ITmfContext)context);
        Assert.assertNull((String)"Event", (Object)event);
    }

    @Test
    public void testSeekEventOnNullTimestamp() {
        ITmfContext context = this.fTrace.seekEvent(null);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOnTimestampOnCacheBoundary() {
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)1001L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)4001L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)4000L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4000L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4001L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOnTimestampNotOnCacheBoundary() {
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)2L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)2L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)10L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)9L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)9L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)10L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)1000L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)999L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)999L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)1002L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1002L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)4501L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)4500L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4500L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOnTimestampOutOfScope() {
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)-1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = this.fTrace.seekEvent(TmfTimestamp.create((long)10001L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", null, (Object)event);
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", null, (Object)event);
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOnNegativeRank() {
        ITmfContext context = this.fTrace.seekEvent(-1L);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
    }

    @Test
    public void testSeekOnRankOnCacheBoundary() {
        ITmfContext context = this.fTrace.seekEvent(0L);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = this.fTrace.seekEvent(1000L);
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        context = this.fTrace.seekEvent(4000L);
        Assert.assertEquals((String)"Event rank", (long)4000L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4000L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4001L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4001L, (long)context.getRank());
    }

    @Test
    public void testSeekOnRankNotOnCacheBoundary() {
        ITmfContext context = this.fTrace.seekEvent(9L);
        Assert.assertEquals((String)"Event rank", (long)9L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)9L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)10L, (long)context.getRank());
        context = this.fTrace.seekEvent(999L);
        Assert.assertEquals((String)"Event rank", (long)999L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)999L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1000L, (long)context.getRank());
        context = this.fTrace.seekEvent(1001L);
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1001L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1002L, (long)context.getRank());
        context = this.fTrace.seekEvent(4500L);
        Assert.assertEquals((String)"Event rank", (long)4500L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4500L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekEventOnRankOutOfScope() {
        ITmfContext context = this.fTrace.seekEvent(-1L);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = this.fTrace.seekEvent(10000L);
        Assert.assertEquals((String)"Event rank", (long)10000L, (long)context.getRank());
        event = this.fTrace.parseEvent(context);
        Assert.assertNull((String)"Event", (Object)event);
        Assert.assertEquals((String)"Event rank", (long)10000L, (long)context.getRank());
        event = this.fTrace.getNext(context);
        Assert.assertNull((String)"Event", (Object)event);
        Assert.assertEquals((String)"Event rank", (long)10000L, (long)context.getRank());
    }

    @Test
    public void testParseEvent() {
        int NB_READS = 20;
        TmfContext context = (TmfContext)this.fTrace.seekEvent(TmfTimestamp.create((long)0L, (int)SCALE));
        TmfContext svContext = new TmfContext(context);
        ITmfEvent event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        Assert.assertTrue((String)"parseEvent", (boolean)context.equals((Object)svContext));
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        Assert.assertTrue((String)"parseEvent", (boolean)context.equals((Object)svContext));
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        Assert.assertTrue((String)"parseEvent", (boolean)context.equals((Object)svContext));
        int i = 1;
        while (i < 20) {
            event = this.fTrace.getNext((ITmfContext)context);
            Assert.assertEquals((String)"Event timestamp", (long)i, (long)event.getTimestamp().getValue());
            ++i;
        }
        svContext = new TmfContext(context);
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)20L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)19L, (long)context.getRank());
        Assert.assertTrue((String)"parseEvent", (boolean)context.equals((Object)svContext));
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)20L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)19L, (long)context.getRank());
        Assert.assertTrue((String)"parseEvent", (boolean)context.equals((Object)svContext));
    }

    @Test
    public void testGetNextAfteSeekingOnTS_1() {
        ITmfEvent event;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)1L, (int)SCALE));
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfteSeekingOnTS_2() {
        ITmfEvent event;
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)2L, (int)SCALE));
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(2L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfteSeekingOnTS_3() {
        ITmfEvent event;
        long INITIAL_TS = 500L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(TmfTimestamp.create((long)500L, (int)SCALE));
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)520L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)519L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfterSeekingOnRank_1() {
        ITmfEvent event;
        long INITIAL_RANK = 0L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(0L);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(0L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(0L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfterSeekingOnRank_2() {
        ITmfEvent event;
        long INITIAL_RANK = 1L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(1L);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfterSeekingOnRank_3() {
        ITmfEvent event;
        long INITIAL_RANK = 500L;
        int NB_READS = 20;
        ITmfContext context = this.fTrace.seekEvent(500L);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)520L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_1() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = null;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        TmfContext context = this.fTrace.seekEvent(INITIAL_LOC);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext((ITmfContext)context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_2() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = this.fTrace.seekEvent(1L).getLocation();
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        TmfContext context = this.fTrace.seekEvent(INITIAL_LOC);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext((ITmfContext)context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_3() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = this.fTrace.seekEvent(500L).getLocation();
        long INITIAL_TS = 501L;
        int NB_READS = 20;
        TmfContext context = this.fTrace.seekEvent(INITIAL_LOC);
        int i = 0;
        while (i < 20) {
            event = this.fTrace.getNext((ITmfContext)context);
            Assert.assertEquals((String)"Event timestamp", (long)(501L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = this.fTrace.parseEvent((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testGetNextLocation() {
        ITmfContext context1 = this.fTrace.seekEvent(0L);
        this.fTrace.getNext(context1);
        ITmfLocation location = context1.getLocation();
        ITmfEvent event1 = this.fTrace.getNext(context1);
        TmfContext context2 = this.fTrace.seekEvent(location);
        ITmfEvent event2 = this.fTrace.getNext((ITmfContext)context2);
        Assert.assertEquals((String)"Event timestamp", (long)event1.getTimestamp().getValue(), (long)event2.getTimestamp().getValue());
    }

    @Test
    public void testGetNextEndLocation() {
        ITmfContext context1 = this.fTrace.seekEvent(this.fTrace.getNbEvents() - 1L);
        this.fTrace.getNext(context1);
        ITmfLocation location = context1.getLocation();
        TmfContext context2 = this.fTrace.seekEvent(location);
        ITmfEvent event = this.fTrace.getNext((ITmfContext)context2);
        Assert.assertNull((String)"Event", (Object)event);
    }

    @Test
    public void testProcessEventRequestForAllEvents() throws InterruptedException {
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 10000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)10000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 10000) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessEventRequestForNbEvents() throws InterruptedException {
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessEventRequestForSomeEvents() throws InterruptedException {
        long startTime = 100L;
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.create((long)100L, (int)SCALE), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(100L + (long)i), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessEventRequestForOtherEvents() throws InterruptedException {
        int startIndex = 99;
        long startTime = 100L;
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.create((long)100L, (int)SCALE), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 99L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(100L + (long)i), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessDataRequestForSomeEvents() throws InterruptedException {
        int startIndex = 100;
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, 100L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(101 + i), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testCancel() throws InterruptedException {
        int limit = 500;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 10000, ITmfEventRequest.ExecutionType.FOREGROUND){
            int nbRead;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.nbRead = 0;
            }

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
                if (++this.nbRead == 500) {
                    this.cancel();
                }
            }
        };
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        providers[0].sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)500L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
    }

    @Test
    public void testDefaultTmfTraceStub() {
        Assert.assertFalse((String)"Open trace", (this.fTrace == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"getEventType", ITmfEvent.class, (Object)this.fTrace.getEventType());
        Assert.assertNull((String)"getResource", (Object)this.fTrace.getResource());
        Assert.assertEquals((String)"getStreamingInterval", (long)0L, (long)this.fTrace.getStreamingInterval());
        Assert.assertEquals((String)"getName", (Object)TEST_TRACE.getPath(), (Object)this.fTrace.getName());
        Assert.assertEquals((String)"getNbEvents", (long)10000L, (long)this.fTrace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)this.fTrace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)10000L, (long)this.fTrace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)this.fTrace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)10000L, (long)this.fTrace.getEndTime().getValue());
        String expected = "TmfTrace [fPath=" + this.fTrace.getPath() + ", fCacheSize=" + this.fTrace.getCacheSize() + ", fNbEvents=" + this.fTrace.getNbEvents() + ", fStartTime=" + this.fTrace.getStartTime() + ", fEndTime=" + this.fTrace.getEndTime() + ", fStreamingInterval=" + this.fTrace.getStreamingInterval() + "]";
        Assert.assertEquals((String)"toString", (Object)expected, (Object)this.fTrace.toString());
    }

    @Test
    public void testCurrentTimeValues() throws TmfTraceException {
        TmfTraceStub trace = null;
        File testfile = null;
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            testfile = new File(FileLocator.toFileURL((URL)location).toURI());
            trace = new TmfTraceStub(testfile.toURI().getPath(), 1000, false, null);
            ITmfTimestamp defaultInitRange = TmfTimestamp.fromNanos((long)100000000L);
            Assert.assertEquals((String)"getInitialRangeOffset", (Object)defaultInitRange, (Object)trace.getInitialRangeOffset());
            trace.setInitialRangeOffset(TmfTimestamp.fromMillis((long)5L));
            trace.indexTrace(true);
            ITmfTimestamp initRange = TmfTimestamp.fromMillis((long)5L);
            Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)trace.getInitialRangeOffset());
            trace.dispose();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)"URISyntaxException");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException");
        }
    }

    @Test
    public void testTraceHostId() {
        String a = this.fTrace.getHostId();
        Assert.assertEquals((Object)"A-Test-10K", (Object)a);
    }

    @Test
    public void testGetEventAspects() {
        Iterable aspects = this.fTrace.getEventAspects();
        for (ITmfEventAspect aspect : aspects) {
            Assert.assertTrue((boolean)TmfTrace.BASE_ASPECTS.contains(aspect));
        }
    }
}

