/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfEmptyTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public abstract class AbstractIndexTest {
    protected static final int BLOCK_SIZE = 100;
    protected static final int NB_EVENTS = 10000;
    protected long fNbEventsLimit;
    protected static TestTrace fTrace = null;
    private static EmptyTestTrace fEmptyTrace = null;

    @Before
    public void setUp() {
        this.fNbEventsLimit = Long.MAX_VALUE;
        this.setupTrace(this.getTracePath());
    }

    protected String getTracePath() {
        return TmfTestTrace.A_TEST_10K.getFullPath();
    }

    @After
    public void tearDown() {
        fTrace.dispose();
        fTrace = null;
        fEmptyTrace.dispose();
        fEmptyTrace = null;
    }

    protected ITestIndexer createTestIndexer(TestTrace trace) {
        return new TestIndexer((ITmfTrace)trace);
    }

    protected TestTrace createTrace(String path) throws URISyntaxException, IOException, TmfTraceException {
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
        File test = new File(FileLocator.toFileURL((URL)location).toURI());
        TestTrace trace = new TestTrace(test.toURI().getPath(), 100);
        trace.indexTrace(true);
        return trace;
    }

    private synchronized void setupTrace(String path) {
        if (fTrace == null) {
            try {
                fTrace = this.createTrace(path);
            }
            catch (TmfTraceException e) {
                Assert.fail((String)e.getMessage());
            }
            catch (URISyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        if (fEmptyTrace == null) {
            try {
                File file = File.createTempFile("empty", "txt");
                fEmptyTrace = new EmptyTestTrace(file.getAbsolutePath());
            }
            catch (IOException | TmfTraceException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void testTmfTraceIndexing() {
        AbstractIndexTest.verifyIndexContent();
    }

    protected static void verifyIndexContent() {
        Assert.assertEquals((long)100L, (long)fTrace.getCacheSize());
        Assert.assertEquals((long)10000L, (long)fTrace.getNbEvents());
        Assert.assertEquals((long)1L, (long)fTrace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((long)10000L, (long)fTrace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((long)1L, (long)fTrace.getStartTime().getValue());
        Assert.assertEquals((long)10000L, (long)fTrace.getEndTime().getValue());
        ITmfCheckpointIndex checkpoints = fTrace.getIndexer().getCheckpoints();
        int pageSize = fTrace.getCacheSize();
        Assert.assertTrue((checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((long)10000L, (long)checkpoints.getNbEvents());
        Assert.assertEquals((long)100L, (long)checkpoints.size());
        int i = 0;
        while (i < checkpoints.size()) {
            ITmfCheckpoint checkpoint = checkpoints.get((long)i);
            TmfContext context = new TmfContext(checkpoint.getLocation(), (long)(i * pageSize));
            ITmfEvent event = fTrace.parseEvent((ITmfContext)context);
            Assert.assertEquals((long)context.getRank(), (long)(i * pageSize));
            Assert.assertTrue((checkpoint.getTimestamp().compareTo(event.getTimestamp()) == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testEmptyTmfTraceIndexing() {
        Assert.assertEquals((long)1000L, (long)fEmptyTrace.getCacheSize());
        Assert.assertEquals((long)0L, (long)fEmptyTrace.getNbEvents());
        Assert.assertEquals((Object)TmfTimestamp.BIG_BANG, (Object)fEmptyTrace.getTimeRange().getStartTime());
        Assert.assertEquals((Object)TmfTimestamp.BIG_BANG, (Object)fEmptyTrace.getTimeRange().getEndTime());
        Assert.assertEquals((Object)TmfTimestamp.BIG_BANG, (Object)fEmptyTrace.getStartTime());
        Assert.assertEquals((Object)TmfTimestamp.BIG_BANG, (Object)fEmptyTrace.getEndTime());
        ITmfCheckpointIndex checkpoints = fEmptyTrace.getIndexer().getCheckpoints();
        Assert.assertTrue((checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)checkpoints.size());
    }

    private class EmptyTestTrace
    extends TmfEmptyTraceStub {
        public EmptyTestTrace(String path) throws TmfTraceException {
            super(path);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return new TestIndexer((ITmfTrace)this);
        }

        public ITestIndexer getIndexer() {
            return (ITestIndexer)super.getIndexer();
        }
    }

    static interface ITestIndexer
    extends ITmfTraceIndexer {
        public ITmfCheckpointIndex getCheckpoints();
    }

    protected static class TestIndexer
    extends TmfCheckpointIndexer
    implements ITestIndexer {
        public TestIndexer(ITmfTrace testTrace) {
            super(testTrace, 100);
        }

        @Override
        public ITmfCheckpointIndex getCheckpoints() {
            return this.getTraceIndex();
        }
    }

    protected class TestTrace
    extends TmfTraceStub {
        public TestTrace(String path, int blockSize) throws TmfTraceException {
            super(path, blockSize, false, null);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return AbstractIndexTest.this.createTestIndexer(this);
        }

        public ITestIndexer getIndexer() {
            return (ITestIndexer)super.getIndexer();
        }

        @TmfSignalHandler
        public void testTraceUpdated(TmfTraceUpdatedSignal signal) {
            if (this.getNbEvents() >= AbstractIndexTest.this.fNbEventsLimit) {
                this.dispose();
            }
        }
    }
}

