/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfEventFieldSignExtensionTest {
    private static final @NonNull CtfTestTrace DEBUG_INFO_TRACE = CtfTestTrace.DEBUG_INFO3;
    private CtfTmfTrace trace;

    @Before
    public void setUp() {
        this.trace = CtfTmfTestTraceUtils.getTrace(DEBUG_INFO_TRACE);
    }

    @After
    public void teardown() {
        if (this.trace != null) {
            this.trace.dispose();
        }
    }

    @Test
    public void testUnsignedByte() {
        long[] expectedValues = new long[]{1L, 198L, 5L, 188L, 243L, 141L, 6L, 141L, 119L, 166L, 224L, 160L, 44L, 237L, 230L, 165L, 12L, 87L, 80L, 181L};
        String expectedToString = LongStream.of(expectedValues).mapToObj(i -> "0x" + Long.toHexString(i)).collect(Collectors.joining(", ", "build_id=[", "]"));
        Throwable throwable = null;
        Object var4_5 = null;
        try (CtfIterator iter = (CtfIterator)this.trace.createIterator();){
            iter.advance();
            iter.advance();
            CtfTmfEvent event = iter.getCurrentEvent();
            ITmfEventField field = event.getContent().getField(new String[]{"build_id"});
            long[] values = (long[])field.getValue();
            Assert.assertArrayEquals((long[])expectedValues, (long[])values);
            Assert.assertEquals((Object)expectedToString, (Object)field.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

