/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfEventFieldVariantTest {
    private static final @NonNull String ENUM_ANY = new String("Any");
    private static final @NonNull String ENUM_NAME2 = "choice2";
    private static final @NonNull String ENUM_NAME3 = "choice3";
    private static final int ENUM_VAL1 = 0;
    private static final int ENUM_VAL2 = 1;
    private static final int ENUM_VAL3 = 2;
    private static final @NonNull String ENUM = "enum";
    private static final @NonNull String FIELD1 = "Fiedl1";
    private static final @NonNull String FIELD2 = "Field2";
    private static final @NonNull String FIELD3 = "Field3";
    private static final @NonNull String VARIANT = "variant";
    private static final @NonNull String ROOT = "root";
    private StructDeclaration fDeclaration;

    @Before
    public void createDeclaration() {
        StructDeclaration sDec = new StructDeclaration(0L);
        EnumDeclaration enumDec = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        enumDec.add(0L, 0L, ENUM_ANY);
        enumDec.add(1L, 1L, ENUM_NAME2);
        enumDec.add(2L, 2L, ENUM_NAME3);
        sDec.addField(ENUM, (IDeclaration)enumDec);
        StructDeclaration choice1Dec = new StructDeclaration(0L);
        choice1Dec.addField(FIELD1, (IDeclaration)IntegerDeclaration.INT_8_DECL);
        choice1Dec.addField(FIELD2, (IDeclaration)IntegerDeclaration.INT_8_DECL);
        StructDeclaration choice2Dec = new StructDeclaration(0L);
        choice2Dec.addField(FIELD1, (IDeclaration)IntegerDeclaration.INT_8_DECL);
        choice2Dec.addField(FIELD2, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        choice2Dec.addField(FIELD3, (IDeclaration)IntegerDeclaration.INT_8_DECL);
        VariantDeclaration varDec = new VariantDeclaration();
        varDec.setTag(ENUM);
        varDec.addField(ENUM_ANY, (IDeclaration)choice1Dec);
        varDec.addField(ENUM_NAME2, (IDeclaration)choice2Dec);
        varDec.addField(ENUM_NAME3, (IDeclaration)IntegerDeclaration.INT_8_DECL);
        sDec.addField(VARIANT, (IDeclaration)varDec);
        this.fDeclaration = sDec;
    }

    @Test
    public void testVariantGetField() throws CTFException {
        StructDeclaration decl = this.fDeclaration;
        StructDefinition sDef = null;
        ByteBuffer bb = ByteBuffer.allocateDirect(1024);
        bb.put((byte)0);
        bb.put((byte)3);
        bb.put((byte)4);
        sDef = decl.createDefinition(null, ROOT, new BitBuffer(bb));
        Definition definition = sDef.getDefinition(VARIANT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)definition, (String)VARIANT);
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_ANY}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME2}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME3}));
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_ANY, FIELD1}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{ENUM_ANY, FIELD1}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_ANY, FIELD2}));
        Assert.assertEquals((Object)4L, (Object)result.getField(new String[]{ENUM_ANY, FIELD2}).getValue());
        Assert.assertNull((Object)result.getField(new String[]{ENUM_ANY, FIELD3}));
        Assert.assertNotNull((Object)result.getField(new String[]{"Any", FIELD1}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{"Any", FIELD1}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{"Any", FIELD2}));
        Assert.assertEquals((Object)4L, (Object)result.getField(new String[]{"Any", FIELD2}).getValue());
        Assert.assertNull((Object)result.getField(new String[]{"Any", FIELD3}));
        String testString = "My Test string";
        bb = ByteBuffer.allocateDirect(1024);
        bb.put((byte)1);
        bb.put((byte)3);
        bb.put(testString.getBytes());
        bb.put((byte)0);
        bb.put((byte)4);
        sDef = decl.createDefinition(null, ROOT, new BitBuffer(bb));
        definition = sDef.getDefinition(VARIANT);
        result = CtfTmfEventField.parseField((IDefinition)definition, (String)VARIANT);
        Assert.assertNull((Object)result.getField(new String[]{ENUM_ANY}));
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_NAME2}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME3}));
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_NAME2, FIELD1}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{ENUM_NAME2, FIELD1}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_NAME2, FIELD2}));
        Assert.assertEquals((Object)testString, (Object)result.getField(new String[]{ENUM_NAME2, FIELD2}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_NAME2, FIELD3}));
        Assert.assertEquals((Object)4L, (Object)result.getField(new String[]{ENUM_NAME2, FIELD3}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{"Any", FIELD1}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{"Any", FIELD1}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{"Any", FIELD2}));
        Assert.assertEquals((Object)testString, (Object)result.getField(new String[]{"Any", FIELD2}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{"Any", FIELD3}));
        Assert.assertEquals((Object)4L, (Object)result.getField(new String[]{"Any", FIELD3}).getValue());
        Assert.assertNull((Object)result.getField(new String[]{ENUM_ANY, FIELD1}));
        bb = ByteBuffer.allocateDirect(1024);
        bb.put((byte)2);
        bb.put((byte)3);
        sDef = decl.createDefinition(null, ROOT, new BitBuffer(bb));
        definition = sDef.getDefinition(VARIANT);
        result = CtfTmfEventField.parseField((IDefinition)definition, (String)VARIANT);
        Assert.assertNull((Object)result.getField(new String[]{ENUM_ANY}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME2}));
        Assert.assertNotNull((Object)result.getField(new String[]{ENUM_NAME3}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME3, FIELD1}));
        Assert.assertNull((Object)result.getField(new String[]{ENUM_NAME3, FIELD2}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{ENUM_NAME3}).getValue());
        Assert.assertNotNull((Object)result.getField(new String[]{"Any"}));
        Assert.assertEquals((Object)3L, (Object)result.getField(new String[]{"Any"}).getValue());
        Assert.assertNull((Object)result.getField(new String[]{"Any", FIELD1}));
    }
}

