/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.tracemanager;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfTraceManagerUtilityTest {
    private ITmfTrace fTrace;

    @Before
    public void setup() {
        this.fTrace = CtfTmfTestTraceUtils.getTrace(CtfTestTrace.TRACE2);
        this.fTrace.indexTrace(true);
    }

    @AfterClass
    public static void teardown() {
        CtfTmfTestTraceUtils.dispose(CtfTestTrace.TRACE2);
    }

    @Test
    public void testSupplementaryFileDir() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        String name1 = trace.getName();
        String basePath = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator;
        String expected = String.valueOf(basePath) + name1 + File.separator;
        Assert.assertEquals((Object)expected, (Object)TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
    }

    @Test
    public void testDeleteSupplementaryFiles() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        String suppFilesPath = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        try {
            Assert.assertFalse((boolean)TmfTraceManagerUtilityTest.isDirectoryEmpty(suppFilesPath));
            TmfTraceManager.deleteSupplementaryFiles((ITmfTrace)trace);
            Assert.assertTrue((boolean)TmfTraceManagerUtilityTest.isDirectoryEmpty(suppFilesPath));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isDirectoryEmpty(String dirPath) throws IOException {
        Path path = Paths.get(dirPath, new String[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            return !stream.iterator().hasNext();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

