/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.io.File;
import java.util.Arrays;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;

public final class SWTBotImportWizardUtils {
    public static void selectImportFromDirectory(SWTBot bot, String directoryPath) {
        SWTBotRadio button = bot.radio("Select roo&t directory:");
        button.click();
        SWTBotCombo sourceCombo = bot.comboBox();
        File traceFolderParent = new File(directoryPath);
        sourceCombo.setFocus();
        sourceCombo.setText(traceFolderParent.getAbsolutePath());
        SWTBotText text = bot.text();
        text.setFocus();
    }

    public static void selectImportFromArchive(SWTBot bot, String archivePath) {
        SWTBotRadio button = bot.radio("Select &archive file:");
        button.click();
        SWTBotCombo sourceCombo = bot.comboBox(1);
        sourceCombo.setFocus();
        sourceCombo.setText(new File(archivePath).getAbsolutePath());
        SWTBotText text = bot.text();
        text.setFocus();
    }

    public static void selectItem(SWTBot bot, String ... treePath) {
        SWTBotTree tree = bot.tree();
        bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)tree));
        if (treePath.length == 0) {
            return;
        }
        if (treePath.length == 1) {
            SWTBotTreeItem rootNode = SWTBotUtils.getTreeItem((SWTBot)bot, (SWTBotTree)tree, (String[])treePath);
            rootNode.select();
            rootNode.check();
            return;
        }
        String[] parentPath = Arrays.copyOf(treePath, treePath.length - 1);
        String itemName = treePath[treePath.length - 1];
        SWTBotTreeItem folderNode = SWTBotUtils.getTreeItem((SWTBot)bot, (SWTBotTree)tree, (String[])parentPath);
        folderNode.expand();
        if (folderNode.getNodes().contains(itemName)) {
            folderNode = folderNode.getNode(itemName);
            folderNode.select();
            folderNode.check();
        } else {
            folderNode.select();
            SWTBotTable fileTable = bot.table();
            bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)fileTable));
            bot.waitUntil(ConditionHelpers.isTableItemAvailable((String)itemName, (SWTBotTable)fileTable));
            SWTBotTableItem tableItem = fileTable.getTableItem(itemName);
            tableItem.check();
        }
    }

    public static void selectFolder(SWTBot bot, boolean check, String ... treePath) {
        SWTBotTree tree = bot.tree();
        bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)tree));
        SWTBotTreeItem folderNode = SWTBotUtils.getTreeItem((SWTBot)bot, (SWTBotTree)tree, (String[])treePath);
        folderNode.select();
        if (check) {
            folderNode.check();
        }
    }

    public static void selectFile(SWTBot bot, String fileName, String ... folderTreePath) {
        SWTBotImportWizardUtils.selectFolder(bot, false, folderTreePath);
        SWTBotTable fileTable = bot.table();
        bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)fileTable));
        bot.waitUntil(ConditionHelpers.isTableItemAvailable((String)fileName, (SWTBotTable)fileTable));
        SWTBotTableItem tableItem = fileTable.getTableItem(fileName);
        tableItem.check();
    }

    public static void setOptions(SWTBot bot, int optionFlags, String traceTypeName) {
        SWTBotCombo comboBox = bot.comboBoxWithLabel(Messages.ImportTraceWizard_TraceType);
        if (traceTypeName != null && !traceTypeName.isEmpty()) {
            comboBox.setSelection(traceTypeName);
        } else {
            comboBox.setSelection(ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        }
        SWTBotCheckBox checkBox = bot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        if (checkBox.isEnabled()) {
            if ((optionFlags & 4) != 0) {
                checkBox.select();
            } else {
                checkBox.deselect();
            }
        }
        checkBox = bot.checkBox(Messages.ImportTraceWizard_PreserveFolderStructure);
        if ((optionFlags & 2) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
        checkBox = bot.checkBox(Messages.ImportTraceWizard_ImportUnrecognized);
        if (checkBox.isEnabled()) {
            if ((optionFlags & 8) != 0) {
                checkBox.select();
            } else {
                checkBox.deselect();
            }
        }
        checkBox = bot.checkBox(Messages.ImportTraceWizard_OverwriteExistingTrace);
        if ((optionFlags & 0x10) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
        checkBox = bot.checkBox(Messages.ImportTraceWizard_CreateExperiment);
        if ((optionFlags & 0x20) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
    }

    public static void testEventsTable(SWTWorkbenchBot bot, String editorName, long nbEvents, final String firstEventStr) {
        final SWTBotEditor editor = SWTBotUtils.activeEventsEditor((SWTWorkbenchBot)bot, (String)editorName);
        bot.waitUntil(ConditionHelpers.numberOfEventsInTrace((ITmfTrace)TmfTraceManager.getInstance().getActiveTrace(), (long)nbEvents));
        if (nbEvents == 0L || firstEventStr == null || firstEventStr.isEmpty()) {
            return;
        }
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                SWTBotTable table = editor.bot().table();
                return table.rowCount() > 1;
            }

            public String getFailureMessage() {
                return "No items in table";
            }
        });
        SWTBotTable table = editor.bot().table();
        table.getTableItem(1).select();
        editor.bot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                boolean ret;
                SWTBotTable curTable = editor.bot().table();
                boolean bl = ret = curTable.selection().rowCount() == 1 && curTable.selection().get(0).toString().contains(firstEventStr);
                if (!ret) {
                    curTable.getTableItem(1).select();
                }
                return ret;
            }

            public String getFailureMessage() {
                return "First event not selected.";
            }
        });
    }
}

