/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestInvalidCtfTrace {
    private static final String PROJET_NAME = "TestInvalidCtfTraces";
    private static final Path BASE_PATH = Paths.get("../../ctf/org.eclipse.tracecompass.ctf.core.tests", "traces", "ctf-testsuite", "tests", "1.8");
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private final File fLocation;
    private final String fExpectedMessage;
    private static final Map<String, String> ERRORS;

    static {
        ERRORS = new HashMap<String, String>();
        ERRORS.put("array-redefinition", "MismatchedTokenException(56!=71)");
        ERRORS.put("array-size-identifier", "Is not an integer: x");
        ERRORS.put("array-size-keyword", "NoViableAltException(74@[])");
        ERRORS.put("array-size-negative", "Array length is negative");
        ERRORS.put("array-size-not-present", "NoViableAltException(13@[])");
        ERRORS.put("array-size-string", "Is not an integer: x");
        ERRORS.put("array-size-type-field", "Is not an integer: uint32_t");
        ERRORS.put("array-size-type", "Is not an integer: uint32_t");
        ERRORS.put("integer-encoding-as-string", "Invalid value for encoding");
        ERRORS.put("integer-encoding-invalid", "Invalid value for encoding");
        ERRORS.put("integer-negative-bit-size", "Invalid value for size");
        ERRORS.put("integer-range", "Invalid integer format: 23452397856348975623897562893746589237465289374658923764598237645897234658723648579236");
        ERRORS.put("integer-signed-as-string", "Invalid boolean value");
        ERRORS.put("integer-signed-invalid", "Invalid boolean value svp");
        ERRORS.put("integer-size-as-string", "Invalid value for size");
        ERRORS.put("integer-size-missing", "Invalid boolean value");
        ERRORS.put("struct-align-enum", "Invalid value for alignment");
        ERRORS.put("struct-align-huge", "Invalid integer format: 0xFFFFFFFFU");
        ERRORS.put("struct-align-negative", "Invalid value for alignment : -8");
        ERRORS.put("struct-align-string", "Invalid value for alignment");
        ERRORS.put("struct-align-zero", "Invalid value for alignment : 0");
        ERRORS.put("struct-duplicate-field-name", "Identifier has already been defined:xxx");
        ERRORS.put("struct-duplicate-struct-name", "struct a already defined.");
        ERRORS.put("struct-field-name-keyword", "NoViableAltException(72@[])");
        ERRORS.put("content-size-larger-than-packet-size", "UNKNOWN");
        ERRORS.put("cross-packet-event-alignment-empty-struct", "UNKNOWN");
        ERRORS.put("cross-packet-event-alignment-integer", "UNKNOWN");
        ERRORS.put("cross-packet-event-array-of-integers", "UNKNOWN");
        ERRORS.put("cross-packet-event-float", "UNKNOWN");
        ERRORS.put("cross-packet-event-integer", "UNKNOWN");
        ERRORS.put("cross-packet-event-len-of-sequence", "UNKNOWN");
        ERRORS.put("cross-packet-event-sequence-between-elements", "UNKNOWN");
        ERRORS.put("cross-packet-event-sequence-start", "UNKNOWN");
        ERRORS.put("out-of-bound-empty-event-with-aligned-struct", "UNKNOWN");
        ERRORS.put("out-of-bound-float", "UNKNOWN");
        ERRORS.put("out-of-bound-integer", "UNKNOWN");
        ERRORS.put("out-of-bound-large-sequence-length", "UNKNOWN");
        ERRORS.put("out-of-bound-len-of-sequence", "UNKNOWN");
        ERRORS.put("out-of-bound-packet-header", "UNKNOWN");
        ERRORS.put("out-of-bound-sequence-between-elements", "UNKNOWN");
        ERRORS.put("out-of-bound-sequence-start", "UNKNOWN");
        ERRORS.put("out-of-bound-sequence-within-element", "UNKNOWN");
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getTracePaths() {
        final LinkedList<Object[]> dirs = new LinkedList<Object[]>();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path fileName = dir.getFileName();
                String res = (String)ERRORS.get(fileName.toString());
                if (res != null) {
                    dirs.add(new Object[]{dir.toFile(), res});
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Path badMetadata = BASE_PATH.resolve(Paths.get("regression", "metadata", "fail"));
        try {
            Files.walkFileTree(badMetadata, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dirs;
    }

    public TestInvalidCtfTrace(File location, String errorMessage) {
        this.fLocation = location;
        this.fExpectedMessage = errorMessage;
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)PROJET_NAME);
    }

    @After
    public void teardown() {
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)PROJET_NAME);
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)PROJET_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @Test
    public void testOpen() {
        SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJET_NAME);
        SWTBotUtils.openTrace((String)PROJET_NAME, (String)this.fLocation.getAbsolutePath(), (String)"org.eclipse.linuxtools.tmf.ui.type.ctf", (boolean)false);
        fBot.waitUntil(Conditions.shellIsActive((String)"Open Trace"));
        SWTBotShell shell = fBot.activeShell();
        SWTBot dialogBot = shell.bot();
        String text = dialogBot.label(1).getText();
        dialogBot.button().click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        SWTBotAssert.assertContains((String)this.fExpectedMessage, (String)text);
    }
}

